% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.RSTACQuery}
\alias{print.STACCatalog}
\alias{print.STACCollectionList}
\alias{print.STACCollection}
\alias{print.STACItemCollection}
\alias{print.STACItem}
\title{Printing functions}
\usage{
\method{print}{RSTACQuery}(x, ...)

\method{print}{STACCatalog}(x, ...)

\method{print}{STACCollectionList}(x, n = 10, ...)

\method{print}{STACCollection}(x, ...)

\method{print}{STACItemCollection}(x, n = 10, ..., tail = FALSE)

\method{print}{STACItem}(x, ...)
}
\arguments{
\item{x}{either a \code{RSTACQuery} object expressing a STAC query
criteria or any \code{RSTACDocument}.}

\item{...}{other parameters passed in the functions.}

\item{n}{number of entries to print. Each object has its own rule of
truncation: the \code{STACCollection} objects will print
10 links by default. If the object has less than 20 collections, all
collections will be shown. In \code{STACItemCollection}, 10 features
will be printed by default. To show all entries, use \code{n = Inf}.}

\item{tail}{A \code{logical} value indicating if last features in
STACItemCollection object must be show.}
}
\description{
The print function covers all objects in the rstac package:

\itemize{
\item \code{\link{stac}}: returns a \code{STACCatalog} document from
  \code{/stac} (v0.8.0) or \code{/} (v0.9.0 or v1.0.0) endpoint.
\item \code{\link{stac_search}}: returns a \code{STACItemCollection}
  document from \code{/stac/search} (v0.8.0) or \code{/search}
  (v0.9.0 or v1.0.0) endpoint containing all Items that match
  the provided search predicates.
\item \code{\link{collections}}: implements the \code{/collections} and
  \code{/collections/\{collectionId\}} endpoints. The former returns
  a \code{STACCollectionList} document that lists all collections published
  by the server, and the later returns a single \code{STACCollection}
  document that describes a unique collection.
\item \code{\link{items}}: retrieves a \code{STACItemCollection} document
  from \code{/collections/\{collectionId\}/items} endpoint and a
  \code{STACItem} document from
  \code{/collections/\{collectionId\}/items/\{itemId\}} endpoints.
}

The rstac package objects visualization is based on markdown, a
lightweight markup language. You can paste the output into any
markdown editor for a better visualization.

Call \code{print()} function to print the rstac's objects.
You can determine how many items will be printed using \code{n} parameter.
}
\examples{
\donttest{
# STACItemCollection object
stac_item_collection <-
  stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
  stac_search(collections = "CB4_64_16D_STK-1",
         bbox = c(-47.02148, -12.98314, -42.53906, -17.35063),
         limit = 15) \%>\%
  get_request()

print(stac_item_collection, n = 10)

# STACCollectionList object
stac_collection <-
    stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
    collections() \%>\%
    get_request()

print(stac_collection, n = 5)

# RSTACQuery object
obj_rstac <- stac("https://brazildatacube.dpi.inpe.br/stac/")

print(obj_rstac)
}
}
\seealso{
\code{\link{stac}} \code{\link{stac_search}} \code{\link{collections}}
\code{\link{items}}
}
