% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_gamm4.R
\name{stan_gamm4}
\alias{stan_gamm4}
\title{Bayesian generalized linear additive models with group-specific terms via
Stan}
\usage{
stan_gamm4(formula, random = NULL, family = gaussian(), data = list(),
  weights = NULL, subset = NULL, na.action, knots = NULL,
  drop.unused.levels = TRUE, ..., prior = normal(),
  prior_intercept = normal(), prior_ops = prior_options(),
  prior_covariance = decov(), prior_PD = FALSE, algorithm = c("sampling",
  "meanfield", "fullrank"), adapt_delta = NULL, QR = FALSE)
}
\arguments{
\item{formula, random, family, data, knots, drop.unused.levels}{Same as for 
\code{\link[gamm4]{gamm4}}.}

\item{subset, weights, na.action}{Same as \code{\link[stats]{glm}}, 
but rarely specified.}

\item{...}{Further arguments passed to \code{\link[rstan]{sampling}} (e.g. 
\code{iter}, \code{chains}, \code{cores}, etc.) or to
\code{\link[rstan]{vb}} (if \code{algorithm} is \code{"meanfield"} or
\code{"fullrank"}).}

\item{prior}{Prior for coefficients. See \code{\link{priors}} for details. 
Set \code{prior} to \code{NULL} to omit a prior, i.e., use an (improper)
uniform prior.}

\item{prior_intercept}{Prior for intercept. See \code{\link{priors}} for 
details. Set \code{prior_intercept} to \code{NULL} to omit a prior, i.e.,
use an (improper) uniform prior. (\strong{Note:} the prior distribution for
the intercept is set so it applies to the value when all predictors are 
centered.)}

\item{prior_ops}{Additional options related to prior distributions. Can 
be \code{NULL} to omit a prior on the dispersion and see 
\code{\link{prior_options}} otherwise.}

\item{prior_covariance}{Cannot be \code{NULL}; see \code{\link{decov}} for
more information about the default arguments.}

\item{prior_PD}{A logical scalar (defaulting to \code{FALSE}) indicating
whether to draw from the prior predictive distribution instead of
conditioning on the outcome.}

\item{algorithm}{Character string (possibly abbreviated) indicating the 
estimation approach to use. Can be \code{"sampling"} for MCMC (the
default), \code{"optimizing"} for optimization, \code{"meanfield"} for
variational inference with independent normal distributions, or
\code{"fullrank"} for variational inference with a multivariate normal
distribution. See \code{\link{rstanarm-package}} for more details on the
estimation algorithms. NOTE: not all fitting functions support all four
algorithms.}

\item{adapt_delta}{Only relevant if \code{algorithm="sampling"}. See 
\code{\link{adapt_delta}} for details.}

\item{QR}{A logical scalar (defaulting to \code{FALSE}) but if \code{TRUE}
applies a scaled \code{\link{qr}} decomposition to the design matrix, 
\eqn{X = Q^\ast R^\ast}{X = Q* R*}, where 
\eqn{Q^\ast = Q \sqrt{n-1}}{Q* = Q (n-1)^0.5} and
\eqn{R^\ast = \frac{1}{\sqrt{n-1}} R}{R* = (n-1)^(-0.5) R}. The coefficients
relative to \eqn{Q^\ast}{Q*} are obtained and then premultiplied by the
inverse of \eqn{R^{\ast}}{R*} to obtain coefficients relative to the
original predictors, \eqn{X}. These transformations do not change the 
likelihood of the data but are recommended for computational reasons when 
there are multiple predictors but you do not have an informative prior on
their coefficients.}
}
\value{
A \link[=stanreg-objects]{stanreg} object is returned 
for \code{stan_gamm4}.
}
\description{
Bayesian inference for GAMMs with flexible priors.
}
\details{
The \code{stan_gamm4} function is similar in syntax to 
  \code{\link[gamm4]{gamm4}}, which accepts a syntax that is similar to (but 
  not quite as extensive as) that for \code{\link[mgcv]{gamm}} and converts 
  it internally into the syntax accepted by \code{\link[lme4]{glmer}}. But 
  rather than performing (restricted) maximum likelihood estimation, the 
  \code{stan_gamm4} function utilizes MCMC to perform Bayesian estimation. 
  The Bayesian model adds independent priors on the common regression 
  coefficients (in the same way as \code{\link{stan_glm}}) and priors on the 
  terms of a decomposition of the covariance matrices of the group-specific 
  parameters, including the smooths. Estimating these models via MCMC avoids
  the optimization issues that often crop up with GAMMs and provides better
  estimates for the uncertainty in the parameter estimates. 
  
  See \code{\link[gamm4]{gamm4}} for more information about the model
  specicification and \code{\link{priors}} for more information about the
  priors.
}
\examples{
# see example(gamm4, package = "gamm4") but prefix gamm4() calls with stan_

}
\seealso{
\code{\link{stanreg-methods}} and 
\code{\link[gamm4]{gamm4}}.
}

