% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_summary.R
\name{prior_summary.stapreg}
\alias{prior_summary.stapreg}
\alias{prior_summary}
\title{Summarize the priors used for an rstap model}
\usage{
\method{prior_summary}{stapreg}(object, digits = 2, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstap} modeling functions. See \code{\link{stapreg-objects}}.}

\item{digits}{Number of digits to use for rounding.}

\item{...}{Currently ignored by the method for stapreg objects.}
}
\value{
A list of class "prior_summary.stapreg", which has its own print
  method.
}
\description{
The \code{prior_summary} method provides a summary of the prior distributions
used for the parameters in a given model. In some cases the user-specified
prior does not correspond exactly to the prior used internally by
\pkg{rstap} (see the sections below). Especially in these cases, but also
in general, it can be much more useful to visualize the priors.
}
\section{Intercept (after predictors centered)}{
 
  For \pkg{rstap} modeling functions that accept a \code{prior_intercept} 
  argument, the specified prior for the intercept term applies to the 
  intercept after \pkg{rstap} internally centers the predictors so they 
  each have mean zero. The estimate of the intercept returned to the user 
  correspond to the intercept with the predictors as specified by the user 
  (unmodified by \pkg{rstap}), but when \emph{specifying} the prior the 
  intercept can be interpreted as the expected outcome when the predictors are
  set to their means.
}

\section{Adjusted scales}{
 For some models you may see "\code{adjusted scale}"
  in the printed output and adjusted scales included in the object returned 
  by \code{prior_summary}. These adjusted scale values are the prior scales 
  actually used by \pkg{rstap} and are computed by adjusting the prior 
  scales specified by the user to account for the scales of the predictors 
  (as described in the documentation for the \code{\link[=priors]{autoscale}}
  argument). To disable internal prior scale adjustments set the 
  \code{autoscale} argument to \code{FALSE} when setting a prior using one of
  the distributions that accepts an \code{autoscale} argument. For example,
  \code{normal(0, 5, autoscale=FALSE)} instead of just \code{normal(0, 5)}. 
  Note that for prior_stap all priors are set on the scaled covariates this is
  done so that multiple priors placed on differing staps can be roughly comparable.
}

\section{Spatial - Temporal Scales}{
 If only one prior was specified this will be returned
in a section entitled "STAP scales". Otherwise no priors will be printed out.
A more structured system for STAP prior printing is planned for the next release.
}

\seealso{
The \link[=priors]{priors help page} and the \emph{Prior
  Distributions} vignette from the \pkg{rstanarm} package.
}
