% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict.stapreg}
\alias{posterior_predict.stapreg}
\alias{posterior_predict}
\title{Draw from posterior predictive distribution}
\usage{
\method{posterior_predict}{stapreg}(object, newsubjdata = NULL,
  newdistdata = NULL, newtimedata = NULL, draws = NULL,
  subject_ID = NULL, group_ID = NULL, re.form = NULL, fun = NULL,
  seed = NULL, offset = NULL, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstap} modeling functions. See \code{\link{stapreg-objects}}.}

\item{newsubjdata}{Optionally, a data frame of the subject-specific data
in which to look for variables with which to predict.
If omitted, the original datasets are used. If \code{newsubjdata}
is provided and any variables were transformed (e.g. rescaled) in the data
used to fit the model, then these variables must also be transformed in
\code{newsubjdata}. This only applies if variables were transformed before
passing the data to one of the modeling functions and \emph{not} if
transformations were specified inside the model formula. Also see the Note
section below for a note about using the \code{newdata} argument with with
binomial models.}

\item{newdistdata}{If newsubjdata is provided a data frame of the subject-distance
must also be given for models with a spatial component}

\item{newtimedata}{If newsubjdata is provided, a data frame of the subject-time data
must also be given for models with a temporal component}

\item{draws}{An integer indicating the number of draws to return. The default
and maximum number of draws is the size of the posterior sample.}

\item{subject_ID}{name of column to join on between subject_data and bef_data}

\item{group_ID}{name of column to join on between \code{subject_data} and bef_data that uniquely identifies the correlated groups (e.g. visits,schools). Currently only one group (e.g. a measurement ID) can be accounted for in a spatial temporal setting.}

\item{re.form}{If \code{object} contains \code{\link[=stap_glmer]{group-level}}
parameters, a formula indicating which group-level parameters to
condition on when making predictions. \code{re.form} is specified in the
same form as for \code{\link[lme4]{predict.merMod}}. The default,
\code{NULL}, indicates that all estimated group-level parameters are
conditioned on. To refrain from conditioning on any group-level parameters,
specify \code{NA} or \code{~0}. The \code{newdata} argument may include new
\emph{levels} of the grouping factors that were specified when the model
was estimated, in which case the resulting posterior predictions
marginalize over the relevant variables.}

\item{fun}{An optional function to apply to the results. \code{fun} is found
by a call to \code{\link{match.fun}} and so can be specified as a function
object, a string naming a function, etc.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}

\item{offset}{A vector of offsets. Only required if \code{newsubjdata} is
specified and an \code{offset} argument was specified when fitting the
model.}

\item{...}{optional arguments to pass to pp_args}
}
\value{
A \code{draws} by \code{nrow(newdata)} matrix of simulations from the
  posterior predictive distribution. Each row of the matrix is a vector of 
  predictions generated using a single draw of the model parameters from the 
  posterior distribution. The returned matrix will also have class
  \code{"ppd"} to indicate it contains draws from the posterior predictive
  distribution.
}
\description{
The posterior predictive distribution is the distribution of the outcome
implied by the model after using the observed data to update our beliefs
about the unknown parameters in the model. Simulating data from the posterior
predictive distribution using the observed predictors is useful for checking
the fit of the model. Drawing from the posterior predictive distribution at
interesting values of the predictors also lets us visualize how a
manipulation of a predictor affects (a function of) the outcome(s). With new
observations of predictor variables we can use the posterior predictive
distribution to generate predicted outcomes.
}
\note{
For binomial models with a number of trials greater than one (i.e., not
  Bernoulli models), if \code{newsubjdata} is specified then it must include all
  variables needed for computing the number of binomial trials to use for the
  predictions. For example if the left-hand side of the model formula is
  \code{cbind(successes, failures)} then both \code{successes} and
  \code{failures} must be in \code{newdata}. The particular values of
  \code{successes} and \code{failures} in \code{newdata} do not matter so
  long as their sum is the desired number of trials. If the left-hand side of
  the model formula were \code{cbind(successes, trials - successes)} then
  both \code{trials} and \code{successes} would need to be in \code{newsubjdata},
  probably with \code{successes} set to \code{0} and \code{trials} specifying
  the number of trials.
}
\examples{
if (!exists("example_model")) example(example_model)
yrep <- posterior_predict(example_model)
table(yrep)

\donttest{ 
# If using new data the all pertinent data must be submitted to the function including subject_ID
# The same distance and time datasets below are used in the original function
# Which will associate the same spatio-temporal exposure to this subject's new fixed covariates.
newdata <- data.frame(subj_ID = 1, measure_ID = 1, centered_income = 0, sex = 0, centered_age = 0) 
pps <- posterior_predict(example_model, newsubjdata = newdata,
                         newdistdata= subset(distdata,subj_ID == 1, measure_ID == 1),
                         newtimedata = subset(timedata, subj_ID == 1, measure_ID == 1),
                         subject_ID = "subj_ID", group_ID = "measure_ID" )
}
}
\seealso{
Examples of posterior predictive checking can also be found in the
  \pkg{rstanarm} vignettes and demos.

\code{\link{predictive_error}} and \code{\link{predictive_interval}}.
}
