% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_summary_stats.R
\name{get_summary_stats}
\alias{get_summary_stats}
\title{Compute Summary Statistics}
\usage{
get_summary_stats(data, ..., type = c("full", "common", "robust",
  "five_number", "mean_sd", "mean_se", "mean_ci", "median_iqr",
  "median_mad", "quantile"), show = NULL, probs = seq(0, 1, 0.25))
}
\arguments{
\item{data}{a data frame}

\item{...}{(optional) One or more unquoted expressions (or variable names)
separated by commas. Used to select a variable of interest. If no variable
is specified, then the summary statistics of all numeric variables in the
data frame is computed.}

\item{type}{type of summary statistics. Possible values include: \code{"full",
"common", "robust",  "five_number", "mean_sd", "mean_se", "mean_ci",
"median_iqr", "median_mad", "quantile"}}

\item{show}{a character vector specifying the summary statistics you want to
show. Example: \code{show = c("n", "mean", "sd")}. This is used to filter
the output after computation.}

\item{probs}{numeric vector of probabilities with values in [0,1]. Used only when type = "quantile".}
}
\value{
A data frame containing descriptive statistics, such as: \itemize{
 \item \strong{n}: the number of individuals \item \strong{min}: minimum
 \item \strong{max}: maximum \item \strong{median}: median \item
 \strong{mean}: mean \item \strong{q1, q3}: the first and the third quartile,
 respectively. \item \strong{iqr}: interquartile range \item \strong{mad}:
 median absolute deviation (see ?MAD) \item \strong{sd}: standard deviation
 of the mean \item \strong{se}: standard error of the mean \item \strong{ci}: 95 percent confidence interval of the mean }
}
\description{
Compute summary statistics for one or multiple numeric variables.
}
\examples{
# Full summary statistics
data("ToothGrowth")
ToothGrowth \%>\% get_summary_stats(len)

# Summary statistics of grouped data
# Show only common summary
ToothGrowth \%>\%
  group_by(dose, supp) \%>\%
  get_summary_stats(len, type = "common")

# Robust summary statistics
ToothGrowth \%>\% get_summary_stats(len, type = "robust")

# Five number summary statistics
ToothGrowth \%>\% get_summary_stats(len, type = "five_number")

# Compute only mean and sd
ToothGrowth \%>\% get_summary_stats(len, type = "mean_sd")

# Compute full summary statistics but show only mean, sd, median, iqr
ToothGrowth \%>\%
    get_summary_stats(len, show = c("mean", "sd", "median", "iqr"))

}
