/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DerivedAttribute;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.formula.FormulaNumberElement;

public class DerivedNominalAttribute
extends NominalAttribute
implements DerivedAttribute {
    private Map<String, Double> cache;
    private final Map<String, Integer> valueToIndexCache;
    private FormulaNumberElement formula;

    public DerivedNominalAttribute(String id, List<Value> valuesList) {
        super(id);
        this.allValues = valuesList;
        this.rawValues = new ArrayList();
        this.valueIndicesHash = new Hashtable();
        this.valueToIndexCache = new HashMap<String, Integer>();
    }

    @Override
    public double computeValue(DataRecord instance) {
        int i = 0;
        Iterator<Value> iter = this.allValuesIterator();
        while (iter.hasNext()) {
            Value value = iter.next();
            if (value.isValueContainedInInstance(instance)) {
                this.valueToIndexCache.put(value.getDescription(), i);
                return i;
            }
            ++i;
        }
        return Double.NaN;
    }

    @Override
    public int getIndexOfValue(String s) {
        Integer integer = this.valueToIndexCache.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCache(Iterator<DataRecord> populationInstanceIterator) {
        HashMap<String, Double> newCache = new HashMap<String, Double>();
        while (populationInstanceIterator.hasNext()) {
            DataRecord inst = populationInstanceIterator.next();
            newCache.put(inst.getID(), this.value(inst));
        }
        DerivedNominalAttribute derivedNominalAttribute = this;
        synchronized (derivedNominalAttribute) {
            this.cache = newCache;
        }
    }

    @Override
    public FormulaNumberElement getFormula() {
        return this.formula;
    }

    @Override
    public String getRawValue(int valIndex) {
        throw new UnsupportedOperationException("Derived Attributes have no rawValues!");
    }

    @Override
    protected int getRawValuesCount() {
        return 0;
    }

    @Override
    public double getValue(DataRecord instance) {
        return this.value(instance);
    }

    @Override
    public void setFormula(FormulaNumberElement formula) {
        this.formula = formula;
    }

    public synchronized double value(DataRecord instance) {
        if (this.cache != null) {
            String id = instance.getID();
            Double value = this.cache.get(id);
            if (value == null) {
                value = new Double(this.computeValue(instance));
                this.cache.put(id, value);
            }
            return value;
        }
        return this.computeValue(instance);
    }

    @Override
    public NominalAttribute copy() {
        ArrayList<String> values = new ArrayList<String>(this.getValuesCount());
        int i = 0;
        while (i < this.getRawValuesCount()) {
            values.add(this.getRawValue(i));
            ++i;
        }
        NominalAttribute copiedNominalAttribute = new NominalAttribute(this.getId(), values);
        return copiedNominalAttribute;
    }

    @Override
    public Iterator<Value> usedValuesIterator(IDataRecordSet dataset) {
        return this.allValuesIterator();
    }
}

