/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.converters;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.AttributeBuilder;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.DateAttribute;
import org.vikamine.kernel.data.DefaultAttribute;
import org.vikamine.kernel.data.FullDataRecord;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.SparseDataRecord;
import org.vikamine.kernel.data.StringAttribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.data.converters.ReaderUtils;
import org.vikamine.kernel.util.ProgressBarPopupUpdater;

public class ARFFDataConverter {
    private boolean importStringAttributes = true;
    private boolean isSparse = false;
    private final Collection<Integer> ignoredAttributeIndices = new LinkedList<Integer>();
    private int numAttributesInDataset = 0;
    private DataRecordSet dataset;
    private String datasetName;
    private final Reader reader;
    private final int initialNumInstancesCapacity;
    private final AttributeBuilder basicBuilder;
    private static final String ARFF_RELATION_START = "@relation";
    private static final String ARFF_DATA_START = "@data";
    private static final String ARFF_ATTRIBUTE_START = "@attribute";
    private static final String ARFF_ATTRIBUTE_TYPE_INTEGER = "integer";
    private static final String ARFF_ATTRIBUTE_TYPE_REAL = "real";
    private static final String ARFF_ATTRIBUTE_TYPE_NUMERIC = "numeric";
    private static final String ARFF_ATTRIBUTE_STRING = "string";
    private static final String ARFF_ATTRIBUTE_TYPE_DATE = "date";

    private ARFFDataConverter(Reader reader, int initialNumInstancesCapacity) {
        this.reader = reader;
        this.initialNumInstancesCapacity = initialNumInstancesCapacity;
        this.basicBuilder = new AttributeBuilder();
    }

    public ARFFDataConverter(Reader reader) {
        this(reader, 1000);
    }

    public DataRecordSet createDataRecordSet() throws IOException {
        StreamTokenizer tokenizer = new StreamTokenizer(this.reader);
        this.initTokenizer(tokenizer);
        List<Attribute> attributes = this.readARFFHeader(tokenizer);
        this.dataset = new DataRecordSet(this.datasetName, attributes, this.initialNumInstancesCapacity);
        while (this.readDataRecord(tokenizer)) {
        }
        this.dataset.compactify();
        return this.dataset;
    }

    public IDataRecordSet createSkeletonDataRecordSet() throws IOException {
        StreamTokenizer tokenizer = new StreamTokenizer(this.reader);
        this.initTokenizer(tokenizer);
        List<Attribute> attributes = this.readARFFHeader(tokenizer);
        this.dataset = new DataRecordSet(this.datasetName, attributes, 0);
        return this.dataset;
    }

    private int getNumberOfAttributes() {
        return this.dataset.getNumAttributes();
    }

    private Attribute getAttribute(int index) {
        return this.dataset.getAttribute(index);
    }

    private void initTokenizer(StreamTokenizer tokenizer) {
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.wordChars(33, 255);
        tokenizer.whitespaceChars(44, 44);
        tokenizer.commentChar(37);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.ordinaryChar(123);
        tokenizer.ordinaryChar(125);
        tokenizer.eolIsSignificant(true);
    }

    private void readTillEOL(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() != 10) {
        }
        tokenizer.pushBack();
    }

    private List<Attribute> readARFFHeader(StreamTokenizer tokenizer) throws IOException {
        HashMap<String, Boolean> alreadyReadNamesHash = new HashMap<String, Boolean>();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        ReaderUtils.readFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            ReaderUtils.throwError(tokenizer, "premature end of file");
        }
        if (ARFF_RELATION_START.equalsIgnoreCase(tokenizer.sval)) {
            ReaderUtils.readNextToken(tokenizer, true);
            this.datasetName = tokenizer.sval;
            ReaderUtils.readLastToken(tokenizer, false);
        } else {
            ReaderUtils.throwError(tokenizer, "keyword @relation expected");
        }
        ReaderUtils.readFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            ReaderUtils.throwError(tokenizer, "premature end of file");
        }
        while (ARFF_ATTRIBUTE_START.equalsIgnoreCase(tokenizer.sval)) {
            ProgressBarPopupUpdater.updateProgress();
            ReaderUtils.readNextToken(tokenizer, true);
            String attributeName = tokenizer.sval.trim();
            if (alreadyReadNamesHash.get(attributeName) != null) {
                ReaderUtils.throwError(tokenizer, "Duplicate attribute entry for " + attributeName);
            }
            alreadyReadNamesHash.put(attributeName, true);
            ReaderUtils.readNextToken(tokenizer, true);
            if (tokenizer.ttype == -3) {
                if (tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_TYPE_REAL) || tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_TYPE_INTEGER) || tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_TYPE_NUMERIC)) {
                    this.basicBuilder.buildNumericAttribute(attributeName);
                    attributes.add(this.basicBuilder.getAttribute());
                    ++this.numAttributesInDataset;
                    this.readTillEOL(tokenizer);
                } else if (tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_STRING)) {
                    if (this.isImportStringAttributes() || DefaultAttribute.isIDAttribute(attributeName)) {
                        this.basicBuilder.buildStringAttribute(attributeName);
                        attributes.add(this.basicBuilder.getAttribute());
                    } else {
                        this.ignoredAttributeIndices.add(this.numAttributesInDataset);
                    }
                    ++this.numAttributesInDataset;
                    this.readTillEOL(tokenizer);
                } else if (tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_TYPE_DATE)) {
                    String format = null;
                    if (tokenizer.nextToken() != 10) {
                        if (tokenizer.ttype != -3 && tokenizer.ttype != 39 && tokenizer.ttype != 34) {
                            ReaderUtils.throwError(tokenizer, "not a valid date format");
                        }
                        format = tokenizer.sval;
                        this.readTillEOL(tokenizer);
                    } else {
                        tokenizer.pushBack();
                    }
                    this.basicBuilder.buildDateAttribute(attributeName, format);
                    attributes.add(this.basicBuilder.getAttribute());
                    ++this.numAttributesInDataset;
                } else {
                    ReaderUtils.throwError(tokenizer, "no valid attribute type or invalid enumeration");
                }
            } else {
                ArrayList<String> attributeValues = new ArrayList<String>();
                tokenizer.pushBack();
                if (tokenizer.nextToken() != 123) {
                    ReaderUtils.throwError(tokenizer, "{ expected at beginning of enumeration");
                }
                while (tokenizer.nextToken() != 125) {
                    if (tokenizer.ttype == 10) {
                        ReaderUtils.throwError(tokenizer, "} expected at end of enumeration");
                        continue;
                    }
                    attributeValues.add(tokenizer.sval.trim());
                }
                if (attributeValues.size() == 0) {
                    ReaderUtils.throwError(tokenizer, "no nominal values found");
                }
                this.basicBuilder.buildNominalAttribute(attributeName, attributeValues);
                this.basicBuilder.buildNominalValues();
                attributes.add(this.basicBuilder.getAttribute());
                ++this.numAttributesInDataset;
            }
            ReaderUtils.readLastToken(tokenizer, false);
            ReaderUtils.readFirstToken(tokenizer);
            if (tokenizer.ttype != -1) continue;
            ReaderUtils.throwError(tokenizer, "premature end of file");
        }
        if (!ARFF_DATA_START.equalsIgnoreCase(tokenizer.sval)) {
            ReaderUtils.throwError(tokenizer, "keyword @data expected");
        }
        if (attributes.size() == 0) {
            ReaderUtils.throwError(tokenizer, "no attributes declared");
        }
        return attributes;
    }

    /*
     * Unable to fully structure code
     */
    private double parseDateAttributeValue(DateAttribute dateAttribute, String possibleDate) throws ParseException {
        block8: {
            parsedDate = 0.0;
            try {
                parsedDate = dateAttribute.parseDate(possibleDate);
                break block8;
            }
            catch (ParseException e) {
                lastParseException = null;
                dateParsingSucceeded = false;
                possibleDateFormats = new String[]{"dd/MM/yy", "dd/MM/yyyy", "dd.MM.yy", "dd.MM.yyyy", "yyyy-MM-dd'T'HH:mm:ss"};
                i = 0;
                ** while (i < possibleDateFormats.length)
            }
lbl-1000:
            // 1 sources

            {
                dateFormat = new SimpleDateFormat(possibleDateFormats[i]);
                dateFormat.setLenient(true);
                try {
                    parsedDate = dateFormat.parse(possibleDate).getTime();
                    dateParsingSucceeded = true;
                }
                catch (ParseException ex) {
                    lastParseException = ex;
                }
                if (dateParsingSucceeded) {
                    return parsedDate;
                }
                ++i;
                continue;
            }
lbl23:
            // 1 sources

            if (!dateParsingSucceeded) {
                if (lastParseException == null) {
                    lastParseException = new ParseException("Unknown data format " + possibleDate, 0);
                }
                Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "parseDateAttributeValue", lastParseException);
                throw lastParseException;
            }
        }
        return parsedDate;
    }

    private boolean readSparseDataRecord(StreamTokenizer tokenizer) throws IOException {
        boolean checkForCR = true;
        SparseDataRecord sparse = new SparseDataRecord();
        ReaderUtils.readNextToken(tokenizer, true);
        while (tokenizer.ttype != 125 && tokenizer.ttype != -1) {
            int position = Integer.parseInt(tokenizer.sval);
            ReaderUtils.readNextToken(tokenizer, true);
            if (tokenizer.ttype == 63) {
                sparse.setMissing(position);
            } else {
                NominalAttribute baAttr;
                if (tokenizer.ttype != -3) {
                    ReaderUtils.throwError(tokenizer, "not a valid value");
                }
                if (this.getAttribute(position).isNominal()) {
                    baAttr = (NominalAttribute)this.getAttribute(position);
                    double val = baAttr.getIndexOfValue(tokenizer.sval);
                    if (val == -1.0) {
                        ReaderUtils.throwError(tokenizer, "nominal value not declared in header for attribute: " + this.getAttribute(position));
                    }
                    sparse.setValue(position, val);
                } else if (this.getAttribute(position).isNumeric()) {
                    try {
                        double value = Double.parseDouble(tokenizer.sval);
                        sparse.setValue(position, value);
                    }
                    catch (NumberFormatException e) {
                        ReaderUtils.throwError(tokenizer, "number expected");
                    }
                } else if (this.getAttribute(position).isString()) {
                    baAttr = (StringAttribute)this.getAttribute(position);
                    if (this.isImportStringAttributes() || DefaultAttribute.isIDAttribute(this.getAttribute(position))) {
                        sparse.setValue(position, (double)((StringAttribute)baAttr).addStringValue(tokenizer.sval));
                    }
                } else if (this.getAttribute(position).isDate()) {
                    String possibleDate = tokenizer.sval;
                    try {
                        DateAttribute dateAttr = (DateAttribute)this.getAttribute(position);
                        sparse.setValue(position, this.parseDateAttributeValue(dateAttr, possibleDate));
                    }
                    catch (ParseException e) {
                        ReaderUtils.throwError(tokenizer, "unparseable date: " + possibleDate);
                    }
                } else {
                    ReaderUtils.throwError(tokenizer, "unknown attribute type in column " + position);
                }
            }
            ReaderUtils.readNextToken(tokenizer, true);
        }
        if (checkForCR) {
            ReaderUtils.readLastToken(tokenizer, true);
        }
        this.dataset.add(sparse);
        return true;
    }

    private boolean readFullDataRecord(StreamTokenizer tokenizer) throws IOException {
        boolean checkForCR = true;
        double[] instance = new double[this.getNumberOfAttributes()];
        int i = 0;
        int j = 0;
        while (j < this.numAttributesInDataset) {
            if (j > 0) {
                ReaderUtils.readNextToken(tokenizer, true);
            }
            if (!this.ignoredAttributeIndices.contains(j)) {
                if (tokenizer.ttype == 63) {
                    instance[i] = Value.missingValue();
                } else {
                    NominalAttribute baAttr;
                    if (tokenizer.ttype != -3) {
                        ReaderUtils.throwError(tokenizer, "not a valid value");
                    }
                    if (this.getAttribute(i).isNominal()) {
                        baAttr = (NominalAttribute)this.getAttribute(i);
                        int index = baAttr.getIndexOfValue(tokenizer.sval);
                        if (index == -1) {
                            ReaderUtils.throwError(tokenizer, "nominal value not declared in header");
                        }
                        instance[i] = index;
                    } else if (this.getAttribute(i).isNumeric()) {
                        try {
                            instance[i] = Double.valueOf(tokenizer.sval);
                        }
                        catch (NumberFormatException e) {
                            ReaderUtils.throwError(tokenizer, "number expected");
                        }
                    } else if (this.getAttribute(i).isString()) {
                        baAttr = (StringAttribute)this.getAttribute(i);
                        if (this.isImportStringAttributes() || DefaultAttribute.isIDAttribute(this.getAttribute(i))) {
                            instance[i] = ((StringAttribute)baAttr).addStringValue(tokenizer.sval);
                        }
                    } else if (this.getAttribute(i).isDate()) {
                        String possibleDate = tokenizer.sval;
                        try {
                            DateAttribute dateAttr = (DateAttribute)this.getAttribute(i);
                            instance[i] = this.parseDateAttributeValue(dateAttr, possibleDate);
                        }
                        catch (ParseException e) {
                            ReaderUtils.throwError(tokenizer, "unparseable date: " + possibleDate);
                        }
                    } else {
                        ReaderUtils.throwError(tokenizer, "unknown attribute type in column " + i);
                    }
                }
                ++i;
            }
            ++j;
        }
        if (checkForCR) {
            ReaderUtils.readLastToken(tokenizer, true);
        }
        this.dataset.add(new FullDataRecord(1.0, instance));
        return true;
    }

    private boolean readDataRecord(StreamTokenizer tokenizer) throws IOException {
        ReaderUtils.readFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            return false;
        }
        if (tokenizer.ttype == 123) {
            this.isSparse = true;
            return this.readSparseDataRecord(tokenizer);
        }
        return this.readFullDataRecord(tokenizer);
    }

    public boolean isSparse() {
        return this.isSparse;
    }

    public void setSparse(boolean value) {
        this.isSparse = value;
    }

    public boolean isImportStringAttributes() {
        return this.importStringAttributes;
    }

    public void setImportStringAttributes(boolean importStringAttributes) {
        this.importStringAttributes = importStringAttributes;
    }
}

