/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.creators;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.AttributeBuilder;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.FullDataRecord;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.OntologyConstants;
import org.vikamine.kernel.data.RDFStatement;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.data.creators.AbstractOntologyCreator;
import org.vikamine.kernel.util.ProgressBarPopupUpdater;

public class DTPDataOntologyCreator
extends AbstractOntologyCreator {
    private static final String MISSING_VALUE_STRING = "?";

    public DTPDataOntologyCreator(ResultSet data, String name) throws SQLException {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null!");
        }
        this.dataset = this.loadDataset(data, name);
    }

    private DataRecordSet loadDataset(ResultSet data, String dataSetName) throws SQLException {
        ArrayList<String> header = new ArrayList<String>();
        ResultSetMetaData metaData = data.getMetaData();
        int i = 1;
        while (i <= metaData.getColumnCount()) {
            header.add(metaData.getColumnName(i));
            ++i;
        }
        boolean[] isAttributeNominal = new boolean[header.size()];
        int rowSize = 0;
        while (data.next()) {
            ++rowSize;
            int attributeIndex = 0;
            while (attributeIndex < header.size()) {
                String castedValue;
                Object attributeValue;
                ProgressBarPopupUpdater.updateProgress();
                if (!isAttributeNominal[attributeIndex] && (attributeValue = data.getObject(attributeIndex + 1)) instanceof String && !(castedValue = (String)attributeValue).equals(MISSING_VALUE_STRING)) {
                    isAttributeNominal[attributeIndex] = true;
                }
                ++attributeIndex;
            }
        }
        data.beforeFirst();
        ArrayList domains = new ArrayList();
        int i2 = 0;
        while (i2 < header.size()) {
            domains.add(new ArrayList());
            ++i2;
        }
        while (data.next()) {
            int attributeIndex = 0;
            while (attributeIndex < header.size()) {
                List tempDomain;
                Object attributeValue;
                String castedValue;
                ProgressBarPopupUpdater.updateProgress();
                if (isAttributeNominal[attributeIndex] && !(castedValue = (attributeValue = data.getObject(attributeIndex + 1)) instanceof String ? (String)attributeValue : attributeValue.toString()).equals(MISSING_VALUE_STRING) && !(tempDomain = (List)domains.get(attributeIndex)).contains(castedValue)) {
                    tempDomain.add(castedValue);
                }
                ++attributeIndex;
            }
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(header.size());
        AttributeBuilder attBuilder = new AttributeBuilder();
        int attributeIndex = 0;
        while (attributeIndex < header.size()) {
            ProgressBarPopupUpdater.updateProgress();
            String attributeName = (String)header.get(attributeIndex);
            if (isAttributeNominal[attributeIndex]) {
                attBuilder.buildNominalAttribute(attributeName, (List)domains.get(attributeIndex));
                attBuilder.buildNominalValues();
            } else {
                attBuilder.buildNumericAttribute(attributeName);
            }
            attributes.add(attBuilder.getAttribute());
            ++attributeIndex;
        }
        DataRecordSet dataSet = new DataRecordSet(dataSetName, attributes, rowSize);
        data.beforeFirst();
        while (data.next()) {
            double[] values = new double[dataSet.getNumAttributes()];
            int attributeIndex2 = 0;
            while (attributeIndex2 < header.size()) {
                ProgressBarPopupUpdater.updateProgress();
                Object value = data.getObject(attributeIndex2 + 1);
                if (isAttributeNominal[attributeIndex2]) {
                    String castedValue = value instanceof String ? (String)value : value.toString();
                    if (castedValue.equals(MISSING_VALUE_STRING)) {
                        values[attributeIndex2] = Value.missingValue();
                    } else {
                        List domain = (List)domains.get(attributeIndex2);
                        int index = domain.indexOf(castedValue);
                        values[attributeIndex2] = index;
                    }
                } else if (value instanceof Double) {
                    values[attributeIndex2] = (Double)value;
                }
                ++attributeIndex2;
            }
            dataSet.add(new FullDataRecord(1.0, values));
        }
        return dataSet;
    }

    @Override
    public Ontology createOntology() {
        if (this.dataset == null) {
            throw new IllegalStateException("Dataset is null!");
        }
        Ontology ontology = new Ontology(this.dataset);
        this.createIDAttribute();
        this.copyAttributesToOntology(ontology);
        ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILETYPE_PROPERTY, "dtp"));
        return ontology;
    }
}

