/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import java.util.List;
import org.vikamine.kernel.subgroup.quality.AbstractRankedBasedQF;

public class AreaUnderCurveQF
extends AbstractRankedBasedQF {
    private static final String ID = "Area-under-Curve QF";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return ID;
    }

    @Override
    public double evaluateRanks(int definedPopulationCount, List<Double> ranksSG) {
        int sgSize = ranksSG.size();
        int complementSize = definedPopulationCount - sgSize;
        double rankSum = 0.0;
        for (Double i : ranksSG) {
            rankSum += i.doubleValue();
        }
        double rankSumAll = definedPopulationCount * (definedPopulationCount + 1) / 2;
        double rankSumComplement = rankSumAll - rankSum;
        return this.evaluateFromRankStatistics(sgSize, complementSize, rankSumComplement);
    }

    public double evaluateFromRankStatistics(int sgSize, int complementSize, double rankSumComplement) {
        if (sgSize == 0 || complementSize == 0) {
            return 0.0;
        }
        return (rankSumComplement - (double)(complementSize * (complementSize + 1) / 2)) / (double)(sgSize * complementSize);
    }

    @Override
    public AreaUnderCurveQF clone() {
        return new AreaUnderCurveQF();
    }
}

