/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.examples;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.xpdl.DatasetProvider;
import org.vikamine.kernel.xpdl.FileDatasetProvider;
import org.vikamine.kernel.xpdl.MiningTaskInterpreter;
import org.vikamine.kernel.xpdl.XMLSGPatternExport;

public class XMLTaskRunner {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Missing parameters: First argument specifies the XML task definition, second argument specifies the data source.");
            System.exit(1);
        }
        String inputXMLTaskFilename = args[0];
        String dataSourceFilename = args[1];
        XMLTaskRunner.createResultFile(inputXMLTaskFilename, dataSourceFilename, String.valueOf(inputXMLTaskFilename) + "_result");
        System.out.println("COMPLETE!");
    }

    private static void createResultFile(String sourceFilename, String dataSourceFilename, String resultFilename) throws IOException {
        File sourceFile = new File(sourceFilename);
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("Target File does not exist: " + sourceFilename);
        }
        FileDatasetProvider provider = new FileDatasetProvider(dataSourceFilename);
        MiningTaskInterpreter interpreter = new MiningTaskInterpreter(sourceFile, (DatasetProvider)provider);
        MiningTask task = interpreter.getTask();
        SGSet sgSet = task.performSubgroupDiscovery();
        Document doc = XMLSGPatternExport.getXML(sgSet, task.getOntology());
        new XMLOutputter(Format.getPrettyFormat()).output(doc, (Writer)new FileWriter(new File(resultFilename)));
    }
}

