/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula.operators;

import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.formula.EvaluationData;
import org.vikamine.kernel.formula.FormulaNumberElement;
import org.vikamine.kernel.formula.constants.FormulaAttributePrimitive;
import org.vikamine.kernel.formula.operators.AbstractAttributeArgumentTerm;

public class MinValue
extends AbstractAttributeArgumentTerm
implements FormulaNumberElement {
    public MinValue() {
        super("minValue");
    }

    public MinValue(FormulaAttributePrimitive arg) {
        this();
        this.setArg1(arg);
    }

    @Override
    public synchronized Double eval(EvaluationData data) {
        if (this.getArg1() == null || data.getInstances() == null) {
            return null;
        }
        double min = Double.NaN;
        for (DataRecord inst : data.getInstances()) {
            EvaluationData d = new EvaluationData();
            d.setInstance(inst);
            double value = this.getArg1().eval(data);
            if (!Double.isNaN(min) && !(min > value)) continue;
            min = value;
        }
        return new Double(min);
    }
}

