/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.persistence;

import java.text.ParseException;
import java.util.HashSet;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.AttributeProvider;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.persistence.SelectorMarshaller;
import org.vikamine.kernel.persistence.ValuesMarshaller;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.NumericSelector;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.util.DOMAccessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGSelectorMarshaller
implements SelectorMarshaller {
    @Override
    public void marshall(SGSelector selector, Element element, Document document) {
        Attribute att = selector.getAttribute();
        Element attNode = document.createElement("attribute");
        attNode.appendChild(document.createTextNode(att.getId()));
        element.appendChild(attNode);
        Element valueNode = document.createElement("values");
        attNode.appendChild(valueNode);
        if (selector instanceof SGNominalSelector) {
            for (Value val : ((SGNominalSelector)selector).getValues()) {
                new ValuesMarshaller().createValueNode(document, valueNode, val);
            }
        } else {
            NumericSelector selectorNum = (NumericSelector)selector;
            attNode.setAttribute("lowerBound", String.valueOf(selectorNum.getLowerBound()));
            attNode.setAttribute("upperBound", String.valueOf(selectorNum.getUpperBound()));
        }
    }

    @Override
    public SGSelector unmarshall(Element element, AttributeProvider attributeProvider, Ontology ontology) throws ParseException {
        String id = DOMAccessor.getChildNodeText(element, "attribute");
        Attribute att = attributeProvider.getAttribute(id);
        if (att == null) {
            throw new ParseException("Unknown attribute: " + id, -1);
        }
        if (att instanceof NominalAttribute) {
            HashSet<Value> values = new HashSet<Value>();
            NodeList valuesNode = element.getElementsByTagName("values");
            if (valuesNode.getLength() != 1) {
                throw new ParseException("No values-node", -1);
            }
            NodeList valueNodes = valuesNode.item(0).getChildNodes();
            int i = 0;
            while (i < valueNodes.getLength()) {
                Node node = valueNodes.item(i);
                if (node instanceof Element) {
                    values.add(new ValuesMarshaller().parseValueNode(attributeProvider, ontology, (Element)node));
                }
                ++i;
            }
            return new DefaultSGSelector(att, values);
        }
        boolean cfr_ignored_0 = att instanceof NumericAttribute;
        return null;
    }
}

