/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.quality.constraints.IConstraint;
import org.vikamine.kernel.subgroup.search.SDMethod;
import org.vikamine.kernel.subgroup.selectors.SGSelector;

public class SimpleDFS
extends SDMethod {
    Collection<IConstraint> constraints;
    KBestSGSet result;

    @Override
    public String getName() {
        return "SimpleDFS";
    }

    @Override
    protected SGSet search(SG initialSubgroup) {
        this.result = SGSets.createKBestSGSet(this.task.getMaxSGCount(), this.task.getMinQualityLimit());
        this.searchInternal(initialSubgroup.getSGDescription().getSelectors(), this.getSelectorSet(initialSubgroup, this.task.getTarget()));
        return this.result;
    }

    private void searchInternal(List<SGSelector> prefix, List<SGSelector> modificationSet) {
        if (this.isAborted()) {
            return;
        }
        if (this.getMethodStats() != null) {
            this.getMethodStats().increaseNodeCounter();
        }
        SG subgroup = new SG(this.task.getOntology().getDataView(), this.task.getTarget(), new SGDescription(new ArrayList<SGSelector>(prefix)));
        subgroup.createStatistics();
        if (subgroup.getStatistics().getSubgroupSize() < this.task.getMinSubgroupSize()) {
            return;
        }
        if (subgroup.getTarget().isBoolean() && ((SGStatisticsBinary)subgroup.getStatistics()).getTp() < this.task.getMinTPSupportAbsolute()) {
            return;
        }
        double quality = this.task.getQualityFunction().evaluate(subgroup);
        if (this.result.isInKBestQualityRange(quality)) {
            subgroup.createStatistics();
            subgroup.setQuality(quality);
            this.result.addByReplacingWorstSG(subgroup);
        }
        if (prefix.size() < this.task.getMaxSGDSize()) {
            Iterator<SGSelector> modifyIter = modificationSet.iterator();
            while (modifyIter.hasNext()) {
                SGSelector sel = modifyIter.next();
                prefix.add(sel);
                modifyIter.remove();
                this.searchInternal(prefix, new ArrayList<SGSelector>(modificationSet));
                prefix.remove(sel);
            }
        }
    }

    @Override
    public boolean isTreatMissingAsUndefinedSupported() {
        return false;
    }
}

