/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import java.util.Collection;
import java.util.Collections;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.SGTarget;

public abstract class SGStatistics {
    protected int descriptionLength = 0;
    protected final SG subgroup;
    protected Options options;
    protected double definedPopulationCount = 0.0;
    protected double undefinedPopulationCount = 0.0;
    protected double subgroupSize;

    protected abstract void calculateStatistics();

    protected SGStatistics(SG subgroup) {
        this.subgroup = subgroup;
        this.options = null;
        this.descriptionLength = subgroup.getSGDescription().size();
    }

    protected SGStatistics(SG subgroup, Options options) {
        this.subgroup = subgroup;
        this.options = options;
        this.descriptionLength = subgroup.getSGDescription().size();
        this.calculateStatistics();
    }

    protected boolean treatMissingAsDefinedValueForAttributes(Collection dmAttributes) {
        if (this.options == null) {
            return true;
        }
        for (Attribute att : dmAttributes) {
            if (!this.options.getBooleanAttributeOption(att, Options.TREAT_MISSING_NOT_AS_DEFINED_VALUE)) continue;
            return false;
        }
        return true;
    }

    public boolean isTargetDefinedInInstance(SGTarget target, DataRecord instance) {
        if (target.isBoolean() && this.treatMissingAsDefinedValueForAttributes(target.getAttributes())) {
            return true;
        }
        return this.isTargetDefinedForTargetAttributes(target, instance);
    }

    private boolean isTargetDefinedForTargetAttributes(SGTarget target, DataRecord instance) {
        for (Attribute att : target.getAttributes()) {
            if (!att.isMissingValue(instance)) continue;
            return false;
        }
        return true;
    }

    public boolean isSGSelectorSetDefinedInInstance(DataRecord instance) {
        if (this.options == null) {
            return true;
        }
        for (SGSelector sel : this.subgroup.getSGDescription()) {
            if (this.isAttributeDefinedInInstance(instance, sel.getAttribute())) continue;
            return false;
        }
        return true;
    }

    public boolean isAttributeDefinedInInstance(DataRecord instance, Attribute attribute) {
        return this.options == null || !instance.isMissing(attribute) || this.treatMissingAsDefinedValueForAttributes(Collections.singletonList(attribute));
    }

    public abstract double getDeviation();

    public abstract double getTargetQuantitySG();

    public abstract double getTargetQuantityPopulation();

    public boolean isInstanceDefinedForSubgroupVars(DataRecord instance) {
        if (this.subgroup.getTarget() != null && !this.isTargetDefinedInInstance(this.subgroup.getTarget(), instance)) {
            return false;
        }
        return this.isSGSelectorSetDefinedInInstance(instance);
    }

    public double getDefinedPopulationCount() {
        return this.definedPopulationCount;
    }

    public double getSubgroupSize() {
        return this.subgroupSize;
    }

    public double getSubgroupShareOfPopulation() {
        return this.getSubgroupSize() / this.getDefinedPopulationCount();
    }

    public double getRelativeSubgroupSize() {
        return this.getSubgroupSize() / this.getDefinedPopulationCount();
    }

    public double getUndefinedPopulationCount() {
        return this.undefinedPopulationCount;
    }

    public SG getSubgroup() {
        return this.subgroup;
    }

    public Options getOptions() {
        return this.options;
    }

    public String toString() {
        return "SGStatistics for (" + SG.verbalizeSGAsPrologLikeRule(this.getSubgroup()) + ")\n" + "DataView: " + this.definedPopulationCount + "(" + this.undefinedPopulationCount + ")\n" + "\n" + "SubgroupSize: " + this.subgroupSize + "\n";
    }

    public int getDescriptionLength() {
        return this.descriptionLength;
    }

    public abstract boolean isBinary();
}

