/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import org.vikamine.kernel.xpdl.EConstraintTyp;
import org.vikamine.kernel.xpdl.IConstraint;
import org.vikamine.kernel.xpdl.MConstraintBoolean;
import org.vikamine.kernel.xpdl.MConstraintIntEnumeration;
import org.vikamine.kernel.xpdl.MConstraintNumeric;
import org.vikamine.kernel.xpdl.XMLException;

public abstract class MConstraintBuilder {
    public static IConstraint build(String value, String x) {
        EConstraintTyp typ = EConstraintTyp.valueOf(x);
        try {
            if (typ.equals((Object)EConstraintTyp.maxK)) {
                return new MConstraintNumeric(Double.parseDouble(value), typ);
            }
            if (typ.equals((Object)EConstraintTyp.minQuality)) {
                return new MConstraintNumeric(Double.parseDouble(value), typ);
            }
            if (typ.equals((Object)EConstraintTyp.maxSelectors)) {
                if (value.contains(",")) {
                    return new MConstraintIntEnumeration(MConstraintBuilder.parseIntEnumeration(value), typ);
                }
                return new MConstraintNumeric(Double.parseDouble(value), typ);
            }
            if (typ.equals((Object)EConstraintTyp.minSubgroupSize)) {
                return new MConstraintNumeric(Double.parseDouble(value), typ);
            }
            if (typ.equals((Object)EConstraintTyp.minTPSupportRelative)) {
                return new MConstraintNumeric(Double.parseDouble(value), typ);
            }
            if (typ.equals((Object)EConstraintTyp.minTPSupportAbsolute)) {
                return new MConstraintNumeric(Double.parseDouble(value), typ);
            }
            if (typ.equals((Object)EConstraintTyp.relevantSubgroupsOnly)) {
                return new MConstraintBoolean(Boolean.parseBoolean(value), typ);
            }
            if (typ.equals((Object)EConstraintTyp.weightedCovering)) {
                return new MConstraintBoolean(Boolean.parseBoolean(value), typ);
            }
            if (typ.equals((Object)EConstraintTyp.ignoreDefaultValues)) {
                return new MConstraintBoolean(Boolean.parseBoolean(value), typ);
            }
            return null;
        }
        catch (NumberFormatException e) {
            throw new XMLException("ungueltiger Constrainwert");
        }
    }

    private static int[] parseIntEnumeration(String value) {
        String[] ints = value.split(",");
        int[] result = new int[ints.length];
        int i = 0;
        while (i < result.length) {
            result[i] = Integer.parseInt(ints[i].trim());
            ++i;
        }
        return result;
    }
}

