% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ie_contracts}
\alias{ie_contracts}
\title{Get federal contract details}
\usage{
ie_contracts(agency_id = NULL, agency_name = NULL,
  contracting_agency_id = NULL, contracting_agency_name = NULL,
  current_amount = NULL, fiscal_year = NULL, maximum_amount = NULL,
  place_district = NULL, place_state_code = NULL,
  requesting_agency_id = NULL, requesting_agency_name = NULL,
  obligated_amount = NULL, vendor_city = NULL, vendor_district = NULL,
  vendor_duns = NULL, vendor_name = NULL, vendor_parent_duns = NULL,
  vendor_state = NULL, vendor_zipcode = NULL, page = NULL,
  per_page = NULL, return = "table", key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{agency_id}{The FIPS code for the agency.}

\item{agency_name}{Full-text search on the name of the agency.}

\item{contracting_agency_id}{The FIPS code for the contracting agency.}

\item{contracting_agency_name}{Full-text search on the name of the contracting agency.}

\item{current_amount}{Current value of the contract in US dollars in one of the following
formats: 500 (exactly 500 dollars), >|500 (greater than or equal to 500 dollars),
<|500 (less than or equal to 500 dollars)}

\item{fiscal_year}{The year in which the grant was awarded. A YYYY formatted year (2006 - 2010)}

\item{maximum_amount}{Maximum possible value of the contract in US dollars
(see \code{current_amount}).}

\item{place_district}{The congressional district in which the contract action will be performed.}

\item{place_state_code}{FIPS code for state in which the contract action will be performed.}

\item{requesting_agency_id}{The FIPS code for the requesting agency.}

\item{requesting_agency_name}{Full-text search on the name of the contracting agency.}

\item{obligated_amount}{The amount obligated or de-obligated by the transaction in US dollars
(see \code{current_amount}).}

\item{vendor_city}{Full-text search on the name of the primary city in which the contractor does
business.}

\item{vendor_district}{The primary congressional district in which the contractor does business.}

\item{vendor_duns}{The Dun and Bradstreet number assigned to the contractor.}

\item{vendor_name}{Full-text search on the name of the contractor.}

\item{vendor_parent_duns}{The Dun and Bradstreet number assigned to the corporate parent of the
contractor.}

\item{vendor_state}{The primary state in which the contractor does business.}

\item{vendor_zipcode}{The primary zipcode in which the contractor does business.}
}
\value{
Details on federal government contracts in a list.
}
\description{
Get federal contract details
}
\examples{
\dontrun{
ie_contracts(vendor_city='indianapolis', page=1, per_page=5)

library('httr')
ie_contracts(vendor_city='indianapolis', page=1, per_page=5, config=verbose())[,c(1:5)]
}
}

