% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ie_industries}
\alias{ie_industries}
\title{Organization aggregates: Search for contributions to politicians.}
\usage{
ie_industries(method = NULL, entity_id = NULL, cycle = NULL,
  limit = NULL, page = NULL, per_page = NULL, return = "table",
  key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{method}{(character) The query string. One of top_ind or top_org.}

\item{entity_id}{(character) The transparencydata ID to look up.}

\item{cycle}{(character) Filter results to a particular type of entity. One of politician,
organization, individual or industry.}

\item{limit}{(integer) Limit number of records returned.}

\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}
}
\value{
A list. Depends on parameters used. Ranges from a single ID returned to basic
information about the the contributions to and from each entity.
}
\description{
Organization aggregates: Search for contributions to politicians.
}
\examples{
\dontrun{
# Top industries, By contributions given, in dollars.
ie_industries(method='top_ind', limit=1)
ie_industries(method='top_ind', limit=4)

# Top organizations in an industry by dollars contributed
ie_industries(method='top_org', entity_id='165d820dd48441e1befdc47f3fa3d236')
}
}

