% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsurfer.R
\name{fsimport}
\alias{fsimport}
\title{'Freesurfer' Import (Serialise)}
\usage{
fsimport(subjectDir, fields = fsimport.listfields(), verbose = F)
}
\arguments{
\item{subjectDir}{The directory containing the subject subdirectories}

\item{fields}{The field groups to use, see fsimport() for more details}

\item{verbose}{Whether to log the 'Freesurfer' scripts to the R console}
}
\value{
The subject data processed from 'Freesurfer'
}
\description{
This function assumes all the subdirectories of subjectDir are subjects who have been processed in 'Freesurfer'. In then runs various 'Freesurfer' scripts to extract the specified fields into an R data frame.
}
\details{
The field groups which can be imported from the subject are:
The specified fields can be:

lh.cortical.thickness = left hemisphere cortical thicknesses
rh.cortical.thickness = right hemisphere cortical thicknesses
lh.cortical.volume = left hemisphere cortical volumes
rh.cortical.volume = right hemisphere cortical volumes
lh.cortical.thickness.std = left hemisphere cortical thickness standard deviations
rh.cortical.thickness.std = right hemisphere cortical thickness standard deviations
lh.cortical.area = left hemisphere cortical surface areas
rh.cortical.area = right hemisphere cortical surface areas
lh.subcortical = left hemisphere subcortical volumes
rh.subcortical = right hemisphere subcortical volumes
lh.hippocampal = left hemisphere hippocampal volumes
rh.hippocampal = right hemisphere hippocampal volumes

By default all of the above fields are included. For the hippocampal volumes, the subjects must have been processed with the "hippo-subfields" when 'Freesurfer' was invoked.
}
\examples{
\dontrun{
setfshome("/Applications/freesurfer")
fsimport("/Users/alex/Desktop/Subjects")
}
}
\author{
Alexander Luke Spedding, \email{alexspedding271@gmail.com}
}
