% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsurfer.R
\name{caddementia.mergewithfreesurferoutput}
\alias{caddementia.mergewithfreesurferoutput}
\title{CAD Dementia Merge With 'Freesurfer' Output}
\usage{
caddementia.mergewithfreesurferoutput(df)
}
\arguments{
\item{df}{The data frame of data imported using fsimport()}
}
\value{
The input data frame merged with Age, Gender and Diagnosis
}
\description{
Merges the Diagnosis, Age, and Gender for CAD Dementia subjects with the post-processed 'Freesurfer' data, note that the rownames of the input data frame must be the Subject IDs i.e. train_vumc_011 of the CAD Dementia data
}
\details{
Test data Diagnoses are returned as NAs
}
\examples{
\dontrun{
setfshome("/Applications/freesurfer")
df <- fsimport.serialise("~/CADDementiaSubjects/", "~/CADSubjects.rds", verbose = T)
caddementia.setfiles("train.txt", "test.txt")
df <- caddementia.mergewithfreesurferoutput(df)
}
}
\author{
Alexander Luke Spedding, \email{alexspedding271@gmail.com}
}
