% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRow.R
\name{addRow}
\alias{addRow}
\alias{addRow,data.frame-method}
\title{Add row(s) to a dataframe.}
\usage{
addRow(targetDataframe, value)

\S4method{addRow}{data.frame}(targetDataframe, value)
}
\arguments{
\item{targetDataframe}{Dataframe.}

\item{value}{Dataframe, character string vector, or list. Columns in value should be a subset of columns in targetDataframe.}
}
\value{
A dataframe with new rows.
}
\description{
Adds row(s) to a dataframe.
}
\details{
Preserves the types and factor levels of the targetDataframe.
Fills missing values if possible using factor levels.
If value is a named vector or list, it will be converted to a single row dataframe.
If value is an unnamed vector or list, the number of elements should equal the number of columns in the targetDataframe; elements are assumed to be in same order as dataframe columns.
}
