% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disableAddon.R
\name{disableAddon}
\alias{disableAddon}
\alias{disableAddon,character-method}
\alias{disableAddon,SsimLibrary-method}
\title{Disable addon or addons.}
\usage{
disableAddon(ssimLibrary, name)

\S4method{disableAddon}{character}(ssimLibrary, name)

\S4method{disableAddon}{SsimLibrary}(ssimLibrary, name)
}
\arguments{
\item{ssimLibrary}{SsimLibrary}

\item{name}{Character string or vector of addon names}
}
\value{
This function invisibly returns `TRUE` upon success (i.e.successful deactivation of the addon 
and `FALSE` upon failure.
}
\description{
Disable addon or addons of an SsimLibrary, or Project/Scenario with an associated SsimLibrary.
}
\examples{
\donttest{
temp_dir <- tempdir()
myses <- session()
myLibrary <- ssimLibrary(name = file.path(temp_dir,"testlib"), session = myses)

enableAddon(myLibrary, c("stsimecodep"))
addon(myLibrary)
disableAddon(myLibrary, c("stsimecodep"))
addon(myLibrary)
}

}
