% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_sort.R
\name{sort_at_path}
\alias{sort_at_path}
\title{Sort substructure of a TableTree at a particular Path in the Tree.}
\usage{
sort_at_path(
  tt,
  path,
  scorefun,
  decreasing = NA,
  na.pos = c("omit", "last", "first")
)
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a populated table.}

\item{path}{character. A vector path for a position within the structure of a tabletree. Each element represents a subsequent choice amongst the children of the previous choice.}

\item{scorefun}{function. Scoring function, should accept the type of children directly under the position at \code{path} (either VTableTree, VTableRow, or VTableNodeInfo, which covers both) and return a numeric value to be sorted.}

\item{decreasing}{logical(1). Should the the scores generated by \code{scorefun} be sorted in decreasing order. If unset (the default of \code{NA}), it is set to \code{TRUE} if the generated scores are numeric and \code{FALSE} if they are characters.}

\item{na.pos}{character(1). What should be done with children (subtrees/rows) with \code{NA} scores. Defaults to \code{"omit"}, which removes them, other allowed values are \code{"last"}  and \code{"first"} which indicate where they should be placed in the order.}
}
\value{
A TableTree with the same structure as \code{tt} with the exception that the requested sorting has been done at \code{path}
}
\description{
Sort substructure of a TableTree at a particular Path in the Tree.
}
\details{
The \code{path} here can include \code{"*"} as a step, which means taht each child at that step will be \emph{separately} sorted based on \code{scorefun} and the remaining \code{path} entries. This can occur multiple times in a path.
}
