% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{split_cols_by}
\alias{split_cols_by}
\title{Declaring a column-split based on levels of a variable}
\usage{
split_cols_by(
  lyt,
  var,
  labels_var = var,
  split_label = var,
  split_fun = NULL,
  format = NULL,
  nested = TRUE,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  ref_group = NULL
)
}
\arguments{
\item{lyt}{layout object pre-data used for tabulation}

\item{var}{string, variable name}

\item{labels_var}{string, name of variable containing labels to be displayed for the values of \code{var}}

\item{split_label}{string. Label string to be associated with the table generated by the split. Not to be confused with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{split_fun}{function/NULL. custom splitting function See \code{\link{custom_split_funs}}}

\item{format}{FormatSpec. Format associated with this split. Formats can be declared via strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can character vectors or lists of functions.}

\item{nested}{boolean, Add this as a new top-level split  (defining a new subtable directly under root). Defaults to \code{FALSE}}

\item{child_labels}{string. One of \code{"default"}, \code{"visible"}, \code{"hidden"}. What should the display behavior be for the  labels (ie label rows) of the children of this split. Defaults to \code{"default"} which flags the label row as visible only if the child has 0 content rows.}

\item{extra_args}{list. Extra arguments to be passed to the tabulation function. Element position in thte list corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do not match a formal argument of the ttabulation function.}

\item{ref_group}{character(1) or \code{NULL}. Level of \code{var} which should be considered ref_group/reference}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{build_table}.
}
\description{
Will generate children for each subset of a categorical variable
}
\section{Custom Splitting Function Details}{


User-defined custom split functions can perform any type of computation
on the incoming data provided that they meed the contract for generating
'splits' of the incoming data 'based on' the split object.

Split functions are functions that accept:
\describe{
\item{df}{data.frame of incoming data to be split}
\item{spl}{a Split object. this is largely an internal detail custom functions will not need to worry about,
but  \code{obj_name(spl)}, for example, will give the name of the split as it will appear in paths in the resulting table}
\item{vals}{Any pre-calculated values. If given non-null values, the values returned should match these. Should be NULL in most cases and can likely be ignored}
\item{labels}{Any pre-calculated value labels. Same as above for \code{values}}
\item{trim}{If \code{TRUE}, resulting splits that are empty should be removed}
\item{(Optional) .spl_context}{a data.frame describing previously performed splits which collectively arrived at \code{df}}
}

The function must then output a \code{named list} with the following elements:

\describe{
\item{values}{The vector of all values corresponding to the splits of \code{df}}
\item{datasplit}{a list of data.frames representing the groupings of the actual observations from \code{df}.}
\item{labels}{a character vector giving a string label for each value listed in the \code{values} element above}
\item{(Optional) extras}{If present, extra arguments to be passed to summary and analysis functions
whenever they are executed on the corresponding element of \code{datasplit} or a subset thereof}
}

One way to generate custom splitting functions is to wrap existing split functions and modify either
the incoming data before they are called, or their outputs.
}

\examples{

lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze(c("AGE", "BMRKR2"))

build_table(lyt, ex_adsl)

# Let's look at the splits in more detail

l <- basic_table() \%>\% split_cols_by("ARM")
l

# add an analysis (summary)
l2 <- l \%>\%
    analyze(c("AGE", "COUNTRY"), afun = list_wrap_x(summary) , format = "xx.xx")
l2

build_table(l2, DM)

# By default sequentially adding layouts results in nesting
library(dplyr)
DM_MF <- DM \%>\% filter(SEX \%in\% c("M", "F")) \%>\% mutate(SEX = droplevels(SEX))

l3 <- basic_table() \%>\% split_cols_by("ARM") \%>\%
  split_cols_by("SEX") \%>\%
  analyze(c("AGE", "COUNTRY"), afun = list_wrap_x(summary), format = "xx.xx")
l3

 build_table(l3, DM_MF)

# nested=TRUE vs not
l4 <- basic_table() \%>\% split_cols_by("ARM") \%>\%
 split_rows_by("SEX", split_fun = drop_split_levels) \%>\%
 split_rows_by("RACE", split_fun = drop_split_levels) \%>\%
 analyze("AGE")

l4
build_table(l4, DM)

l5 <- basic_table() \%>\% split_cols_by("ARM") \%>\%
 split_rows_by("SEX", split_fun= drop_split_levels) \%>\%
 analyze("AGE") \%>\%
 split_rows_by("RACE", nested=FALSE, split_fun = drop_split_levels) \%>\%
 analyze("AGE")

l5
build_table(l5, DM)


}
\author{
Gabriel Becker
}
