% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_table_struct.R
\name{sanitize_table_struct}
\alias{sanitize_table_struct}
\title{Sanitize degenerate table structures (Experimental)}
\usage{
sanitize_table_struct(tt, empty_msg = "-- This Section Contains No Data --")
}
\arguments{
\item{tt}{\code{TableTree}}

\item{empty_msg}{character(1). The string which should be spanned across
the inserted empty rows.}
}
\value{
If \code{tt} is already valid, it is returned unmodified. If \code{tt} is
degenerate, a modified, non-degenerate version of the table is returned.
}
\description{
Experimental function to correct structure
of degenerate tables by adding messaging rows to empty
sub-structures.
}
\details{
This function locates degenerate portions of the table (including the table
overall in the case of a table with no data rows) and inserts a row
which spans all columns with the message \code{empty_msg} at each one,
generating a table guaranteed to be non-degenerate.
}
\examples{

sanitize_table_struct(rtable("cool beans"))

lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("SEX") \%>\%
  summarize_row_groups()

## Degenerate because it doesn't have any analyze calls -> no data rows
badtab <- build_table(lyt, DM)
sanitize_table_struct(badtab)
}
