% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{split_cols_by_multivar}
\alias{split_cols_by_multivar}
\title{Associate multiple variables with columns}
\usage{
split_cols_by_multivar(
  lyt,
  vars,
  split_fun = NULL,
  varlabels = vars,
  varnames = NULL,
  nested = TRUE,
  extra_args = list()
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout object pre-data used for tabulation.}

\item{vars}{(\code{character})\cr vector of variable names.}

\item{split_fun}{(\code{function} or \code{NULL})\cr custom splitting function. See \link{custom_split_funs}.}

\item{varlabels}{(\code{character})\cr vector of labels for \code{vars}.}

\item{varnames}{(\code{character})\cr vector of names for \code{vars} which will appear in pathing. When \code{vars} are all
unique this will be the variable names. If not, these will be variable names with suffixes as necessary to enforce
uniqueness.}

\item{nested}{(\code{logical})\cr whether this layout instruction should be applied within the existing layout structure
\emph{if possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split
underneath analyses, which is not allowed.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{\link[=build_table]{build_table()}}.
}
\description{
In some cases, the variable to be ultimately analyzed is most naturally defined on a column, not a row, basis.
When we need columns to reflect different variables entirely, rather than different levels of a single
variable, we use \code{split_cols_by_multivar}.
}
\examples{
library(dplyr)

ANL <- DM \%>\% mutate(value = rnorm(n()), pctdiff = runif(n()))

## toy example where we take the mean of the first variable and the
## count of >.5 for the second.
colfuns <- list(
  function(x) in_rows(mean = mean(x), .formats = "xx.x"),
  function(x) in_rows("# x > 5" = sum(x > .5), .formats = "xx")
)

lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_cols_by_multivar(c("value", "pctdiff")) \%>\%
  split_rows_by("RACE",
    split_label = "ethnicity",
    split_fun = drop_split_levels
  ) \%>\%
  summarize_row_groups() \%>\%
  analyze_colvars(afun = colfuns)
lyt

tbl <- build_table(lyt, ANL)
tbl

}
\seealso{
\code{\link[=analyze_colvars]{analyze_colvars()}}
}
\author{
Gabriel Becker
}
