/*--------------------------------------------------------------------*/
/*     Copyright (C) 2004-2010  Serge Iovleff

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this program; if not, write to the
    Free Software Foundation, Inc.,
    59 Temple Place,
    Suite 330,
    Boston, MA 02111-1307
    USA

    Contact : S..._Dot_I..._At_stkpp_Dot_org (see copyright for ...)
*/

/*
 * Project:  stkpp::classification
 * created on: 13 sept. 2010
 * Purpose:  main header file of the project classification.
 * Author:   iovleff, S..._Dot_I..._At_stkpp_Dot_org (see copyright for ...)
 *
 **/

/** @file Classification.h
 *  @brief This file include all the header files of the project Classification.
 **/

/**
 * @defgroup Classif Classification
 * @brief The project Classification propose a set of classes for implementing
 * classifiers.
 *
 * In machine learning and statistics, classification is the problem of
 * identifying to which of a set of categories (sub-populations) a new
 * observation belongs, on the basis of a training set of data containing
 * observations (or instances) whose category membership is known. An example
 * would be assigning a given email into "spam" or "non-spam" classes or
 * assigning a diagnosis to a given patient as described by observed
 * characteristics of the patient (gender, blood pressure, presence or absence
 * of certain symptoms, etc.). Classification is an example of pattern
 * recognition.
 *
 * In the terminology of machine learning, classification is considered an
 * instance of supervised learning, i.e. learning where a training set of
 * correctly identified observations is available. The corresponding
 * unsupervised procedure is known as clustering, and involves grouping data
 * into categories based on some measure of inherent similarity or distance.
 *
 * Often, the individual observations are analyzed into a set of quantifiable
 * properties, known variously as explanatory variables or features. These
 * properties may variously be categorical (e.g. "A", "B", "AB" or "O", for
 * blood type), ordinal (e.g. "large", "medium" or "small"), integer-valued
 * (e.g. the number of occurrences of a particular word in an email) or
 * real-valued (e.g. a measurement of blood pressure). Other classifiers work
 * by comparing observations to previous observations by means of a similarity
 * or distance function.
 *
 * An algorithm that implements classification, especially in a concrete
 * implementation, is known as a classifier. The term "classifier" sometimes
 * also refers to the mathematical function, implemented by a classification
 * algorithm, that maps input data to a category.
 **/

/** @ingroup Classif
 *  @namespace STK::Classif
 *  @brief This namespace encloses all variables and constant specific to the
 *  Classification project.
 **/



#ifndef CLASSIFICATION_H
#define CLASSIFICATION_H

#include <Classification/include/STK_IClassification.h>

#endif /* CLASSIFICATION_H */
