% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_params.R
\name{tau2tau}
\alias{tau2tau}
\alias{set_taus_equal}
\title{Set process completion times equal}
\usage{
tau2tau(model, names, keep_zeros = FALSE)

set_taus_equal(model, names, keep_zeros = FALSE)
}
\arguments{
\item{model}{A list of the class \code{rtmpt_model}.}

\item{names}{Character vector giving the names of the processes for which the process completion times should be equal. If 
\code{length(names) = 1} then the corresponding process completion times (for negative and positive outcomes) will be 
estimates (i.e., they will be set to NA)}

\item{keep_zeros}{Can be one of the following
\itemize{
 \item logical value: \code{FALSE} (default) means none of the zeros for \code{names} in the \code{model} will be kept; The times of
   the reference process (i.e., first of \code{names} in alphabetical order) will be set to \code{NA} (i.e., will be estimated) and the others
   will be set to the name of the reference process (i.e., will be set to equal the reference process times). \code{TRUE} means
   the zero(s) of the reference process times (if specified) is used for the same outcome of all other processes. 
 \item numeric value: index for \code{names}. If 1, the zero(s) of the first process in \code{names} (in original order defined by the user) is 
   used for the same outcome of all other processes in \code{names}. If 2, the zero(s) of the second process is used. And so on.
}}
}
\value{
A list of the class \code{rtmpt_model}.
}
\description{
Setting multiple process completion times (taus) equal. This means all process times of negative outcomes will be
  set equal and all process times of positive outcomes will be set equal. Only two process times (one for the negative
  and one for the positive outcome) of the named processes will be estimated. The equality can be removed by just 
  naming only one process name.
}
\note{
If you use \code{theta2theta()} and \code{tau2tau()} with the same process names you might just change the EQN or MDL file accordingly
  by using the same process name for all processes which should have equal process times and probabilities.
}
\examples{
####################################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times are assumed to be equal for each category.
# The process completion times for both detection processes ("do" and "dn") will be
# set equal.
####################################################################################

mdl_2HTM <- "
# targets
do+(1-do)*g
(1-do)*(1-g)

# lures
(1-dn)*g
dn+(1-dn)*(1-g)

# do: detect old; dn: detect new; g: guess
"

model <- to_rtmpt_model(mdl_file = mdl_2HTM)

## make do = dn
new_model <- tau2tau(model = model, names = c("do", "dn"))
new_model


## make do = dn
new_model <- set_taus_equal(model = model, names = c("do", "dn"))
new_model
}
\seealso{
\code{\link{delta2delta}}, \code{\link{theta2const}}, \code{\link{tau2zero}} and \code{\link{theta2theta}}
}
\author{
Raphael Hartmann
}
