% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_model.R
\name{to_ertmpt_model}
\alias{to_ertmpt_model}
\alias{to_rtmpt_model}
\title{Create a model list to fit an RT-MPT}
\usage{
to_ertmpt_model(eqn_file = NULL, mdl_file = NULL)

to_rtmpt_model(eqn_file = NULL, mdl_file = NULL)
}
\arguments{
\item{eqn_file}{Character string as shown in example 2 or path to the text file that specifies the 
(RT-)MPT model with standard .eqn syntax (Heck et al., 2018; Hu, 1999). E.g. \code{studied ; hit ; (1-do)*g} for a correct guess 
in the detect-guess 2HT model.}

\item{mdl_file}{Character string as shown in example 1 or path to the text file that specifies the 
(RT-)MPT model and gives on each line the equation of one category using \code{+} to separate branches 
and \code{*} to separate processes (Singmann and Kellen, 2013). E.g. \code{do+(1-do)*g} for the category "hit" in the detect-guess 
2HT model.}
}
\value{
A list of the class \code{ertmpt_model}.
}
\description{
Create a model list of the class \code{ertmpt_model} by providing either \code{eqn_file} or \code{mdl_file}.
If both are provided \code{mdl_file} will be used.
}
\note{
Within a branch of a (RT-)MPT model it is not allowed to have the same process two or more times.
}
\examples{
########################################################################################
# Detect-Guess variant of the Two-High Threshold model
#   with constant guessing and
#   suppressed process completion times for both failed detections.
# The encoding and motor execution times are assumed to be different for each response.
########################################################################################

## 1. using the mdl syntax
mdl_2HTM <- "
# targets
do+(1-do)*g     ; 0
(1-do)*(1-g)    ; 1

# lures
(1-dn)*g        ; 0
dn+(1-dn)*(1-g) ; 1

# do: detect old; dn: detect new; g: guess

# OPTIONAL MPT CONSTRAINTS
# for constant thetas and suppressed taus
# please use theta2cons() and tau2
"

model <- to_ertmpt_model(mdl_file = mdl_2HTM)
model

## 2. using the eqn syntax
eqn_2HTM <- "
# CORE MPT EQN
# tree ; cat ; mpt
     0 ;   0 ; do
     0 ;   0 ; (1-do)*g
     0 ;   1 ; (1-do)*(1-g)
       
     1 ;   2 ; (1-dn)*g
     1 ;   3 ; dn
     1 ;   3 ; (1-dn)*(1-g)

# OPTIONAL MPT CONSTRAINTS
# for constant thetas and suppressed taus
# please use theta2cons() and tau2

#     tree ; cat ;  MAP
resp:    0 ;   0 ;    0
resp:    0 ;   1 ;    1
resp:    1 ;   2 ;    0
resp:    1 ;   3 ;    1
# different motor execution times for old and new responses.
"

model <- to_ertmpt_model(eqn_file = eqn_2HTM)
model


mdl_2HTM <- "
# targets
do+(1-do)*g     ; 0
(1-do)*(1-g)    ; 1

# lures
(1-dn)*g        ; 0
dn+(1-dn)*(1-g) ; 1

# do: detect old; dn: detect new; g: guess
"

model <- to_rtmpt_model(mdl_file = mdl_2HTM)
model

}
\references{
Heck, D. W., Arnold, N. R., & Arnold, D. (2018). TreeBUGS: An R package for hierarchical 
  multinomial-processing-tree modeling. \emph{Behavior Research Methods, 50(1)}, 264-284.

Hu, X. (1999). Multinomial processing tree models: An implementation. 
  \emph{Behavior Research Methods, Instruments, & Computers, 31(4)}, 689-695.

Singmann, H., & Kellen, D. (2013). MPTinR: Analysis of multinomial processing tree models in R. 
  \emph{Behavior Research Methods, 45(2)}, 560-575.
}
\seealso{
\code{\link{delta2delta}}, \code{\link{theta2const}}, \code{\link{tau2zero}}, \code{\link{theta2theta}}, and \code{\link{tau2tau}} for 
  functions to change the model
}
\author{
Raphael Hartmann
}
