% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkTrend_rcpp.R
\name{acf.fft}
\alias{acf.fft}
\title{faster autocorrelation based on ffw}
\usage{
acf.fft(x, lag.max = NULL)
}
\arguments{
\item{lag.max}{maximum lag at which to calculate the acf.
    Default is \eqn{10\log_{10}(N/m)}{10*log10(N/m)} where \eqn{N} is the
    number of observations and \eqn{m} the number of series.  Will
    be automatically limited to one less than the number of observations
    in the series.}
}
\value{
An array with the same dimensions as x containing the estimated autocorrelation.
}
\description{
This function is 4-times faster than \code{\link[stats:acf]{stats::acf()}}
}
\examples{
set.seed(1)
x = rnorm(100)
r_acf_fft = acf.fft(x)
r_acf = acf(x, plot = FALSE)$acf[,1,1]
}
\references{
\enumerate{
\item https://gist.github.com/FHedin/05d4d6d74e67922dfad88038b04f621c
\item https://gist.github.com/ajkluber/f293eefba2f946f47bfa
\item http://www.tibonihoo.net/literate_musing/autocorrelations.html#wikispecd
\item https://lingpipe-blog.com/2012/06/08/autocorrelation-fft-kiss-eigen
}
}
\keyword{internal}
