% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arr_3d.R
\name{apply_3d}
\alias{apply_3d}
\title{apply function for 3d array}
\usage{
apply_3d(
  array,
  dim = 3,
  FUN = rowMeans2,
  by = NULL,
  scale = 1,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{array}{A 3d array}

\item{dim}{giving the subscripts to split up data by.}

\item{FUN}{function, should only be row applied function, e.g. \code{matrixStats::rowMeans2},
\code{matrixStats::rowMins}, \code{matrixStats::rowRanges}.
Because 3d array will be convert to matrix first, with the aggregated dim in
the last dimension.}

\item{by}{\itemize{
\item If not provided (\code{NULL}), the aggregated dim will be disappear.
For example, daily precipitation \verb{[nrow, ncol, 31-days]} aggregate into
monthly \verb{[nrow, ncol]}.
\item If provided, \code{by} should be equal to the aggregated \code{dim}.
For example, daily precipitation \verb{[nrow, ncol, 365-days]} aggregate into
monthly \verb{[nrow, ncol, 12-months]}. In that situation, \code{by} should be equal
to 365, and be \code{format(date, '\%Y\%m')}.
}}

\item{scale}{in the same length of \code{by}, or a const value,
\code{value_returned} = \code{FUN(x)*scale}. This parameter is designed for converting
monthly to yearly, meanwhile multiply days in month.
Currently, same group should have the same scale factor. Otherwise, only the
first is used.}
}
\description{
NA values will be removed automatically
}
\examples{
set.seed(1)
size <- c(10, 8, 31)
arr <- array(rnorm(10 * 8 * 31), dim = size)

by <- c(rep(1, 10), rep(2, 21))
r2 <- apply_3d(arr, 3, by = by, FUN = rowMeans)

\dontrun{
arr_yearly <- apply_3d(arr, by = year(dates), scale = days_in_month(dates))
}
}
\seealso{
\link{apply_row} \link[matrixStats:rowRanges]{matrixStats::rowRanges}
}
\keyword{internal}
