% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{rtry_export}
\alias{rtry_export}
\title{Export preprocessed data}
\usage{
rtry_export(data, output, quote = TRUE, encoding = "UTF-8")
}
\arguments{
\item{data}{The data to be saved.}

\item{output}{Output path.}

\item{quote}{Default \code{TRUE} inserts double quotes around any character or factor columns.}

\item{encoding}{Default \code{"UTF-8"}. File encoding.}
}
\value{
No return value, called for exporting a \code{.csv} file.
}
\description{
This function exports the preprocessed data as comma separated values to a \code{.csv} file.
If the specified output directory does not exist, it will be created.
}
\examples{
# Export the preprocessed data to a specific location
rtry_export(data_TRY_15160, file.path(tempdir(), "TRYdata_unprocessed.csv"))

# Expected message:
# File saved at: C:\Users\user\AppData\Local\Temp\Rtmp4wJAvQ/TRYdata_unprocessed.csv
}
\references{
This function makes use of the \code{\link[utils]{write.csv}} function
within the \code{utils} package.
}
