% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_tweets}
\alias{search_tweets}
\title{search_tweets}
\usage{
search_tweets(q, count = 100, type = "mixed", token = NULL, ...)
}
\arguments{
\item{q}{Character vector search query of no greater than
500 characters maximum.}

\item{count}{Numeric specifying the number of desired tweets to
return per page. Defaults to maximum, which is 100.}

\item{type}{Character, specifies what type of search results
you would prefer to receive. The current default is
\code{type = "mixed"}.
Valid values include \code{type = "mixed"} to include both
popular and real time results in the response,
\code{type = "recent"} to return only the most recent results
in the response, and \code{type = "popular"} to return only
the most popular results in the response.}

\item{token}{OAuth token (1.0 or 2.0). By default
\code{token = NULL} fetches a non-exhausted token from
an environment variable tokens.}

\item{\dots}{Futher arguments passed on to \code{make_url}.}
}
\value{
Tweets data returned as a tibble data_frame
}
\description{
Returns a collection of relevant Tweets matching a
  specified query.
}
\examples{
\dontrun{
# search for 1000 tweets mentioning Hillary Clinton
hrc <- search_tweets(q = "hillaryclinton", count = 1000)
hrc

# search for 1000 tweets mentioning Donald Trump
djt <- search_tweets(q = "realdonaldtrump", count = 1000)
djt
}
}
\seealso{
\url{https://dev.twitter.com/overview/documentation}
}

