% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http.R
\name{TWIT_paginate_max_id}
\alias{TWIT_paginate_max_id}
\alias{TWIT_paginate_cursor}
\alias{TWIT_paginate_chunked}
\alias{TWIT_paginate_premium}
\title{Pagination}
\usage{
TWIT_paginate_max_id(
  token,
  api,
  params,
  get_id = function(x) x$id_str,
  n = 1000,
  page_size = 200,
  since_id = NULL,
  max_id = NULL,
  count_param = "count",
  retryonratelimit = NULL,
  verbose = TRUE
)

TWIT_paginate_cursor(
  token,
  api,
  params,
  n = 5000,
  page_size = 5000,
  cursor = "-1",
  get_id = function(x) x$ids,
  retryonratelimit = NULL,
  verbose = TRUE
)

TWIT_paginate_chunked(
  token,
  api,
  params_list,
  retryonratelimit = NULL,
  verbose = TRUE
)

TWIT_paginate_premium(
  token,
  api,
  params,
  n = 100,
  page_size = 100,
  cursor = "next",
  retryonratelimit = NULL,
  verbose = TRUE
)
}
\arguments{
\item{token}{Expert use only. Use this to override authentication for
a single API call. In most cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{get_id}{A single argument function that returns a vector of ids given
the JSON response. The defaults are chosen to cover the most common cases,
but you'll need to double check whenever implementing pagination for
a new endpoint.}

\item{n}{Desired number of results to return. Results are downloaded
in pages when \code{n} is large; the default value will download a single
page. Set \code{n = Inf} to download as many results as possible.

The Twitter API rate limits the number of requests you can perform
in each 15 minute period. The easiest way to download more than that is
to use \code{retryonratelimit = TRUE}.

You are not guaranteed to get exactly \code{n} results back. You will get
fewer results when tweets have been deleted or if you hit a rate limit.
You will get more results if you ask for a number of tweets that's not
a multiple of page size, e.g. if you request \code{n = 150} and the page
size is 200, you'll get 200 results back.}

\item{since_id}{Supply a vector of ids or a data frame of previous results to
find tweets \strong{newer} than \code{since_id}.}

\item{max_id}{Supply a vector of ids or a data frame of previous results to
find tweets \strong{older} than \code{max_id}.}

\item{retryonratelimit}{If \code{TRUE}, and a rate limit is exhausted, will wait
until it refreshes. Most Twitter rate limits refresh every 15 minutes.
If \code{FALSE}, and the rate limit is exceeded, the function will terminate
early with a warning; you'll still get back all results received up to
that point. The default value, \code{NULL}, consults the option
\code{rtweet.retryonratelimit} so that you can globally set it to \code{TRUE},
if desired.

If you expect a query to take hours or days to perform, you should not
rely soley on \code{retryonratelimit} because it does not handle other common
failure modes like temporarily losing your internet connection.}

\item{verbose}{Show progress bars and other messages indicating current
progress?}

\item{cursor}{Which page of results to return. The default will return
the first page; you can supply the result from a previous call to
continue pagination from where it left off.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
These are internal functions used for pagination inside of rtweet.
}
\keyword{internal}
