% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{SparreAndersen-class}
\alias{SparreAndersen-class}
\title{A formal S4 class SparreAndersen}
\description{
A formal S4 class representation of classical Sparre Andersen model.
}
\details{
The model is defined as follows:
\deqn{X(t) = u + ct - \sum_{i=1}^{N(t)} Y_i,}
where \eqn{u} is the initial capital (\code{initial_capital}), \eqn{c} is the
premium rate (\code{premium_rate}), \eqn{N(t)} is the renewal process defined
by distribution of interarrival times (\code{claim_interarrival_generator}
and \code{claim_interarrival_parameters}), \eqn{Y_i} are iid claim sizes
(\code{claim_size_generator} and \code{claim_size_parameters}).

Objects of class can be created only by using the constructor
\code{\link{SparreAndersen}}.
}
\section{Slots}{

\describe{
\item{\code{initial_capital}}{a length one numeric non-negative vector specifying an
initial capital.}

\item{\code{premium_rate}}{a length one numeric non-negative vector specifying a
premium rate.}

\item{\code{claim_interarrival_generator}}{a function indicating the random
generator of claims' interarrival times.}

\item{\code{claim_interarrival_parameters}}{a named list containing parameters for
the random generator of claims' interarrival times.}

\item{\code{claim_size_generator}}{a function indicating the random generator of
claims' sizes.}

\item{\code{claim_size_parameters}}{a named list containing parameters for the
random generator of claims' sizes.}
}}

\references{
\itemize{
\item Andersen, E. Sparre. \emph{On the collective theory of risk in case of
contagion between claims}. Transactions of the XVth International Congress
of Actuaries, 2(6), 1957.
\item Thorin O. \emph{Some Comments on the Sparre Andersen Model in the Risk
Theory}. ASTIN Bulletin: The Journal of the IAA, 8(1):104-125, 1974.
}
}
\seealso{
\code{\link{SparreAndersen}}
}
