% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{dose_records_builder}
\alias{dose_records_builder}
\title{Builds Dose Records Dataframe}
\usage{
dose_records_builder(
  NCA_DS = NULL,
  dose_from = NULL,
  col_id = NULL,
  col_time = NULL,
  col_ntime = NULL,
  col_route = NULL,
  col_dose = NULL,
  col_cycle = NULL,
  col_dur = NULL,
  col_evid = NULL,
  col_analyte = NULL,
  col_group = NULL
)
}
\arguments{
\item{NCA_DS}{Dataset containing dosing records.}

\item{dose_from}{Method of dose extraction either "cols" or "rows".}

\item{col_id}{Name of column with subject ID.}

\item{col_time}{Name of column with time since first dose.}

\item{col_ntime}{Name of column with time since the last dose (required with \code{dose_from="cols"}).}

\item{col_route}{Name of column with route information.}

\item{col_dose}{Name of column with last dose given.}

\item{col_cycle}{Name of column with dose cycle (required with \code{dose_from="cols"}).}

\item{col_dur}{Name of column with dose duration.}

\item{col_evid}{Name of column with event ID (required with \code{dose_from="rows"}).}

\item{col_analyte}{Name of column with analyte (optional).}

\item{col_group}{Names of columns with grouping information (optionl).}
}
\value{
list containing the following elements
\itemize{
\item{isgood:}           Return status of the function.
\item{msgs:}             Messages to be passed back to the user.
\item{dose_rec:}
}
}
\description{
Takes information about columns in dataset and constructs the
dosing records.
}
\examples{

if(system.file(package="readxl") !=""){
library(dplyr)
library(readxl)
library(stringr)

# Example data file:
data_file =  system.file(package="formods","test_data","TEST_DATA.xlsx")

# Dataset formatted to extract dosing from columns
DS_cols = readxl::read_excel(path=data_file, sheet="DATA")        |>
 dplyr::filter(EVID == 0)                                |>
 dplyr::filter(DOSE \%in\% c(3))                           |>
 dplyr::filter(str_detect(string=Cohort, "^MD"))         |>
 dplyr::filter(CMT == "C_ng_ml")

drb_res = dose_records_builder(
 NCA_DS     = DS_cols,
 dose_from  = "cols",
 col_id     = "ID",
 col_time   = "TIME_DY",
 col_ntime  = "NTIME_DY",
 col_route  = "ROUTE",
 col_cycle  = "DOSE_NUM",
 col_dose   = "DOSE",
 col_group  = "Cohort")

utils::head(drb_res$dose_rec)

# Dataset formatted to extract dosing from rows (records)
DS_rows = readxl::read_excel(path=data_file, sheet="DATA")        |>
 dplyr::filter(DOSE \%in\% c(3))                                   |>
 dplyr::filter(str_detect(string=Cohort, "^MD"))                 |>
 dplyr::filter(CMT \%in\% c("Ac", "C_ng_ml"))

drb_res = dose_records_builder(
 NCA_DS     = DS_rows,
 dose_from  = "rows",
 col_id     = "ID",
 col_time   = "TIME_DY",
 col_ntime  = "NTIME_DY",
 col_route  = "ROUTE",
 col_dose   = "AMT",
 col_evid   = "EVID",
 col_group  = "Cohort")

utils::head(drb_res$dose_rec)
}
}
