% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{run_nca_components}
\alias{run_nca_components}
\title{Runs NCA for the Current Analysis}
\usage{
run_nca_components(
  state,
  components = c("nca", "fg_ind_obs", "tb_ind_obs", "tb_ind_params")
)
}
\arguments{
\item{state}{NCA state from \code{NCA_fetch_state()}}

\item{components}{List of components to run. By default it will run all of
the following. If you just need to regenerate a figure based on the current
nca results you can just specify that component. These are the valid
components:
\itemize{
\item{nca:}               Run NCA analysis
\item{fg_ind_obs:}        Build the figure(s) with the indiviudal observations.
\item{tb_ind_obs:}        Build the table(s) with the indiviudal observations.
\item{tb_ind_params:}     Build the table(s) with the indiviudal parameters.
}}
}
\value{
List with the following components:
\itemize{
\item{isgood:}    Return status of the function.
\item{msgs:}      Error messages if any issues were encountered.
\item{nca_res:}   PKNCA results if run was successful.
}
}
\description{
Takes the current state and runs the current analysis in that
state.
}
\examples{
# We need a state object to use below
sess_res = NCA_test_mksession(session=list(), full_session=FALSE)
state = sess_res$state

state = run_nca_components(state, components="tb_ind_params")
}
