% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convert.R
\name{convert_test}
\alias{convert_test}
\title{Convert an RUnit test to a testthat test}
\usage{
convert_test(runit_test_fn,
  test_description = assertive::get_name_in_parent(runit_test_fn))
}
\arguments{
\item{runit_test_fn}{An \code{RUnit} test function.}

\item{test_description}{A string describing the test, defaulting to
the name of the \code{RUnit} test function.}
}
\value{
A call to \code{test_that}, containing a \code{testhat} test
equivalent to the input \code{RUnit} test.
}
\description{
Converts a single RUnit test to a testthat test.
}
\examples{
test_truth <- function()
{
  x <- all(runif(10) > 0)
  checkTrue(x)
}
convert_test(test_truth)
test_equality <- function()
{
  x <- sqrt(1:5)
  expected <- c(1, 4, 9, 16, 25)
  checkEquals(expected, x ^ 4)
}
convert_test(test_equality)
test_error <- function()
{
  checkException("1" + "2")
}
convert_test(test_error)
}
\seealso{
\code{\link{convert_package_tests}}, \code{\link{convert_test_file}}
}

