% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/results.jags.R
\name{results.jags}
\alias{results.JAGS}
\alias{results.jags}
\title{Importing of saved JAGS simulations with partial error recovery}
\usage{
results.jags(foldername, echo = NA, combine = NA, summarise = NA,
  keep.jags.files = NA, read.monitor = NA, return.samples = NA,
  recover.chains = NA, ...)
}
\arguments{
\item{foldername}{the absolute or relative path to the folder containing the JAGS simulation to be imported.  May also be the return value of a call to \code{\link{run.jags}} with method = 'background' or method = 'bgparallel', which will avoid having to re-load some information from disk and therefore may be slightly faster.}

\item{echo}{option to display the output of the simulations to screen.  If the simulations have not finished, the progress-to-date will be displayed.}

\item{combine}{a logical flag indicating if results from the new JAGS run should be combined with the previous chains.  Default value respects the setting chosen during the initial run.jags function call, changing the option to TRUE or FALSE overrides the original setting.}

\item{summarise}{should summary statistics be automatically calculated for the output chains?  Default value respects the setting chosen during the initial run.jags function call, changing the option to TRUE or FALSE overrides the original setting.}

\item{keep.jags.files}{option to keep the folder with files needed to call JAGS, rather than deleting it after importing.  Default value respects the setting chosen during the initial run.jags function call, changing the option to TRUE or FALSE overrides the original setting.  See also the \code{\link{cleanup.jags}} function.}

\item{read.monitor}{an optional character vector of variables to import from the simulation folder.  This may be useful for models with large numbers of variables that would otherwise not be able to be loaded into R.  Default value loads all variables given by the monitor argument (but NOT the noread.monitor argument) to the original run.jags call.}

\item{return.samples}{option to thin the final MCMC chain(s) before calculating summary statistics and returning the chains.  Note that this option does NOT currently carry out thinning in JAGS, therefore R must have enough available memory to hold the chains BEFORE thinning (for very large chains, it may be necessary to specify a subset of the variables at a time using read.monitor='...' and keep.jags.files=TRUE).  Default value returns all available iterations.}

\item{recover.chains}{option to try to recover successful simulations if some simulations failed (this is only relevant for parallel methods with more than 1 simulation).  A value of TRUE returns only successful simulations, FALSE will cause an error if any simulation has failed.  A numeric vector of specific chain(s) to be read is also permitted, but an error will be returned if any of the simulations containing these chains was unsuccessful.  The default version reads the option set in \code{\link{runjags.options}}.}

\item{...}{additional summary parameters to be passed to \code{\link{add.summary}}}
}
\value{
An object of class 'runjags' (see \code{\link{runjags-class}}).
}
\description{
Imports a completed JAGS simulation from a folder created by \code{\link{run.jags}} using the background or bgparallel methods, or any other method where the keep.jags.files=TRUE option was used. Partial recovery simulations is possible for parallel methods where one or more simulation failed to complete. Additional chain thinning and parameter import selection is also supported.
}
\examples{
\dontshow{
runjags.options(new.windows=FALSE)
}
# Run a model using parallel background JAGS calls:

# Simulate the data:
N <- 100
X <- 1:N
Y <- rnorm(N, 2*X + 10, 1)
# Initial values for 2 chains:
m <- list(-10, 10)
c <- list(-10, 10)
precision <- list(0.01, 10)

# Model in the JAGS format
model <- "model {
for(i in 1 : N){
	Y[i] ~ dnorm(true.y[i], precision);
	true.y[i] <- (m * X[i]) + c
}
m ~ dunif(-1000,1000)
c ~ dunif(-1000,1000)
precision ~ dexp(1)
#data# X, Y, N
#monitor# m, c, precision
#inits# m, c, precision
}"

\dontrun{
# Run the model and produce plots
fileinfo <- run.jags(model=model, n.chains=2, method="bgparallel")
# Wait for the simulations to complete:
Sys.sleep(10)
# Import only variable m from the first chain:
results <- results.jags(fileinfo, read.monitor='m', recover.chains=1)
# Look at the summary statistics:
print(results)
}
}
\seealso{
\code{\link{runjags-class}} for details of available methods for the returned object, \code{\link{run.jags}} for details of how to start simulations, and \code{\link{runjags.options}} for user options regarding warning messages etc.
}
\keyword{models}

