% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.R
\name{add.summary}
\alias{add.summary}
\alias{plot.runjags}
\alias{plot.runjagsplots}
\alias{print.runjags}
\alias{print.runjagsplots}
\alias{summary.runjags}
\title{Summary statistics and plot methods for runjags class objects}
\usage{
add.summary(runjags.object, vars = NA, mutate = NA, psrf.target = 1.05,
  normalise.mcmc = TRUE, modeest.opts = list(), confidence = c(0.95),
  autocorr.lags = c(10), custom = NULL,
  silent.jags = runjags.getOption("silent.jags"),
  plots = runjags.getOption("predraw.plots"), plot.type = c("trace", "ecdf",
  "histogram", "autocorr", "key", "crosscorr"), col = NA,
  summary.iters = 20000, trace.iters = 1000, separate.chains = FALSE,
  trace.options = list(), density.options = list(),
  histogram.options = list(), ecdfplot.options = list(),
  acplot.options = list())

\method{summary}{runjags}(object, ...)

\method{plot}{runjags}(x, plot.type = c("trace", "ecdf", "histogram",
  "autocorr", "crosscorr"), vars = NA,
  layout = runjags.getOption("plot.layout"),
  new.windows = runjags.getOption("new.windows"), file = "",
  mutate = NULL, col = NA, trace.iters = NA, separate.chains = NA,
  trace.options = NA, density.options = NA, histogram.options = NA,
  ecdfplot.options = NA, acplot.options = NA, ...)

\method{print}{runjags}(x, vars = NA, digits = 5, ...)

\method{print}{runjagsplots}(x, layout = runjags.getOption("plot.layout"),
  new.windows = runjags.getOption("new.windows"), file = "", ...)

\method{plot}{runjagsplots}(x, layout = runjags.getOption("plot.layout"),
  new.windows = runjags.getOption("new.windows"), file = "", ...)
}
\arguments{
\item{runjags.object}{an object of class \code{\link{runjags-class}}.}

\item{vars}{an optional character vector of variable names.  If supplied, only variable names in the object supplied with a partial match to anything in 'vars' will be used.  Note that regular expressions are not allowed, but the caret (^) token can be used to specify the match at the start of a variable name, and a quoted vars will be matched exactly.  Default NA meaning all variables available are returned.}

\item{mutate}{either a function or a list with first element a function and remaining elements arguments to this function.  This can be used to add new variables to the posterior chains that are derived from the directly monitored variables in JAGS. This allows the variables to be summarised or extracted as part of the MCMC objects as if they had been calculated in JAGS, but without the computational or storage overheads associated with calculating them in JAGS directly.  The plot, summary and as.mcmc methods for runjags objects will automatically extract the mutated variables along with the directly monitored variables.}

\item{psrf.target}{the desired cutoff for 'convergence' as determined Gelman and Rubin's convergence diagnostic (see \code{\link[coda]{gelman.diag}}).  This is somewhat arbitrary, but 1.05 is a commonly used figure.}

\item{normalise.mcmc}{an option test transformations of the monitored variable for improved normality, which is an assumption of the Gelman and Rubin statistic.  Setting this option to FALSE will likely cause problems with calculating the psrf for highly skewed variables.}

\item{modeest.opts}{arguments to be passed to the \code{\link[modeest]{mlv}} function to calculate the mode of continuous variables.  Ignored if the mode.continuous option in \code{\link{runjags.options}} is set to FALSE.}

\item{confidence}{a numeric vector of probabilities (between 0 and 1) on which to base confidence interval calculations.}

\item{autocorr.lags}{a numeric vector of integers on which to base the autocorrelation diagnostic.  See also the autocorr plot type.}

\item{custom}{a custom function which takes a numeric object as input and outputs a single summary statistic.  This statistic will be included with the others in the print and summary method outputs.}

\item{silent.jags}{option to suppress feedback text produced by the summary function when summary statistics must be recalculated.}

\item{plots}{option to pre-draw the plots given by plot.type to facilitate more convinient assessment of convergence after the model has finished running, at the expense of requiring a larger object to stored.  The default value uses the option given in \code{\link{runjags.options}}}

\item{plot.type}{a character vector of plots to produce, from 'trace', 'density', 'ecdf', 'histogram', 'autocorr', 'crosscorr', 'key' or 'all'.  These are all based on the equivalent plots from the \code{\link[lattice]{lattice}} package with some modifications.}

\item{col}{a vector of colours to use for the different chains.  This will be used for all plot types (where relevant), including the 'key' plot which functions to label the chain numbers of the various colours.  The default uses the standard lattice colour palatte for up to 7 chains, with a rainbow palette used for larger numbers of chains, and combined chains shown in dark grey.}

\item{summary.iters}{the number of iterations to thin the chains to before calculating summary statistics (including all plots except the trace plot).  Setting too high a value will cause a long delay while calculating these statistics.}

\item{trace.iters}{the number of iterations to thin the chains to before producing traceplots.  Setting too high a value will cause large file sizes and delays displaying the trace plots.}

\item{separate.chains}{option to display each plot separately for different chains (except crosscorr and key).  If FALSE, either the separate chains will be shown on the same plot (for trace, density, and ecdf) or as a single plot with combined chains (for histogram and autocorr).}

\item{trace.options}{a list of arguments to be passed to the underlying plot function that creates the trace plots.  A colour specification should be specified using the 'col' argument above to ensure that this is the same across plot types.}

\item{density.options}{a list of arguments to be passed to the underlying plot function that creates the density plots.  A colour specification should be specified using the 'col' argument above to ensure that this is the same across plot types.}

\item{histogram.options}{a list of arguments to be passed to the underlying plot function that creates the histogram plots.  A colour specification should be specified using the 'col' argument above to ensure that this is the same across plot types.}

\item{ecdfplot.options}{a list of arguments to be passed to the underlying plot function that creates the ecdf plots.  A colour specification should be specified using the 'col' argument above to ensure that this is the same across plot types.}

\item{acplot.options}{a list of arguments to be passed to the underlying plot function that creates the autocorr plots.  A colour specification should be specified using the 'col' argument above to ensure that this is the same across plot types.}

\item{object}{an object of class \code{\link{runjags-class}}.}

\item{...}{additional arguments to be passed to \code{\link[grDevices]{pdf}} for the plot.runjags method, or the default print method for the print.runjags method.}

\item{x}{an object of class \code{\link{runjags-class}}.}

\item{layout}{the layout of the runjags plots to print, a numeric vector of length 2 stating the number of rows and columns of plots.  The default value is taken from \code{\link{runjags.options}}.}

\item{new.windows}{option to produce each plot (or matrix of plots) on a new graphics window rather than over-writing the previous plots.  For R interfaces where plots can be cycled through (e.g. the OS X GUI and RStudio), it is likely to be preferable to produce all plots to the same device.  The default value is taken from \code{\link{runjags.options}}, which depends on the system.}

\item{file}{an optional filename to which plots can be saved using \code{\link[grDevices]{pdf}}.  The default "" means produce plots in the active graphics device.}

\item{digits}{the number of digits to display for printed numerical output.}
}
\value{
The summary method returns a numeric matrix of summary statistics for each variable (invisibly for the print method), wheras the add.summary function returns an object of class \code{\link{runjags-class}} with the new sumamry statistics (and plots if selected) stored for future use.
}
\description{
Objects of class \code{\link{runjags-class}} have specialised options available for print, plot and summary.  These allow various options for controlling how the output is presented, including sub-selection of variables of interest (using partial matching).
}
\details{
The print method is designed to display option prettily, wheras the summary method is designed to return the central table (summary statistics for each variable) as a numeric matrix that can be assigned to another variable and manipulated by the user.  If summary statistics have been pre-calculated these will be returned without re-calculation by both methods, wheras only the summary method will re-calculate summary statistics if they are not already available.

The add.summary function returns an object of class runjags, with the new summary statistics (and plots if selected) stored internally for future use.  Note that many of the summary method options can be passed to \code{\link{run.jags}} when the model is run and will be remembered for future output, although they can be modified explicitly by subsequent calls to summary or add.summary.  If the summary statistics or plots requested are identical to those stored inside the runjags object, they will not be re-calculated.  Calculation of the mode of continuous variables is possible, but requires the suggested \code{\link[modeest]{modeest}} package.
}
\seealso{
\code{\link{runjags-class}} for details on other methods available for runjags class objects
}
\keyword{methods}

