% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RushWorker.R
\name{RushWorker}
\alias{RushWorker}
\title{Rush Worker}
\value{
Object of class \link[R6:R6Class]{R6::R6Class} and \code{RushWorker} with worker methods.
}
\description{
\link{RushWorker} evaluates tasks and writes results to the data base.
The worker inherits from \link{Rush}.
}
\note{
The worker registers itself in the data base of the rush network.
}
\examples{
# This example is not executed since Redis must be installed
\donttest{
   config_local = redux::redis_config()
   rush = rsh(network_id = "test_network", config = config_local)

   fun = function(x1, x2, ...) list(y = x1 + x2)
   rush$start_local_workers(fun = fun)

   rush$stop_workers()
}
}
\section{Super class}{
\code{\link[rush:Rush]{rush::Rush}} -> \code{RushWorker}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{worker_id}}{(\code{character(1)})\cr
Identifier of the worker.}

\item{\code{remote}}{(\code{logical(1)})\cr
Whether the worker is on a remote machine.}

\item{\code{heartbeat}}{(`r_process``)\cr
Background process for the heartbeat.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{terminated}}{(\code{logical(1)})\cr
Whether to shutdown the worker.
Used in the worker loop to determine whether to continue.}

\item{\code{terminated_on_idle}}{(\code{logical(1)})\cr
Whether to shutdown the worker if no tasks are queued.
Used in the worker loop to determine whether to continue.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RushWorker-new}{\code{RushWorker$new()}}
\item \href{#method-RushWorker-push_running_tasks}{\code{RushWorker$push_running_tasks()}}
\item \href{#method-RushWorker-pop_task}{\code{RushWorker$pop_task()}}
\item \href{#method-RushWorker-push_results}{\code{RushWorker$push_results()}}
\item \href{#method-RushWorker-set_terminated}{\code{RushWorker$set_terminated()}}
\item \href{#method-RushWorker-clone}{\code{RushWorker$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="create_worker_script"><a href='../../rush/html/Rush.html#method-Rush-create_worker_script'><code>rush::Rush$create_worker_script()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="detect_lost_workers"><a href='../../rush/html/Rush.html#method-Rush-detect_lost_workers'><code>rush::Rush$detect_lost_workers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="fetch_failed_tasks"><a href='../../rush/html/Rush.html#method-Rush-fetch_failed_tasks'><code>rush::Rush$fetch_failed_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="fetch_finished_tasks"><a href='../../rush/html/Rush.html#method-Rush-fetch_finished_tasks'><code>rush::Rush$fetch_finished_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="fetch_new_tasks"><a href='../../rush/html/Rush.html#method-Rush-fetch_new_tasks'><code>rush::Rush$fetch_new_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="fetch_priority_tasks"><a href='../../rush/html/Rush.html#method-Rush-fetch_priority_tasks'><code>rush::Rush$fetch_priority_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="fetch_queued_tasks"><a href='../../rush/html/Rush.html#method-Rush-fetch_queued_tasks'><code>rush::Rush$fetch_queued_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="fetch_running_tasks"><a href='../../rush/html/Rush.html#method-Rush-fetch_running_tasks'><code>rush::Rush$fetch_running_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="fetch_tasks"><a href='../../rush/html/Rush.html#method-Rush-fetch_tasks'><code>rush::Rush$fetch_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="fetch_tasks_with_state"><a href='../../rush/html/Rush.html#method-Rush-fetch_tasks_with_state'><code>rush::Rush$fetch_tasks_with_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="format"><a href='../../rush/html/Rush.html#method-Rush-format'><code>rush::Rush$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="is_failed_task"><a href='../../rush/html/Rush.html#method-Rush-is_failed_task'><code>rush::Rush$is_failed_task()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="is_running_task"><a href='../../rush/html/Rush.html#method-Rush-is_running_task'><code>rush::Rush$is_running_task()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="print"><a href='../../rush/html/Rush.html#method-Rush-print'><code>rush::Rush$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="print_log"><a href='../../rush/html/Rush.html#method-Rush-print_log'><code>rush::Rush$print_log()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="push_failed"><a href='../../rush/html/Rush.html#method-Rush-push_failed'><code>rush::Rush$push_failed()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="push_priority_tasks"><a href='../../rush/html/Rush.html#method-Rush-push_priority_tasks'><code>rush::Rush$push_priority_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="push_tasks"><a href='../../rush/html/Rush.html#method-Rush-push_tasks'><code>rush::Rush$push_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="read_hash"><a href='../../rush/html/Rush.html#method-Rush-read_hash'><code>rush::Rush$read_hash()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="read_hashes"><a href='../../rush/html/Rush.html#method-Rush-read_hashes'><code>rush::Rush$read_hashes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="read_log"><a href='../../rush/html/Rush.html#method-Rush-read_log'><code>rush::Rush$read_log()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="reset"><a href='../../rush/html/Rush.html#method-Rush-reset'><code>rush::Rush$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="restart_local_workers"><a href='../../rush/html/Rush.html#method-Rush-restart_local_workers'><code>rush::Rush$restart_local_workers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="retry_tasks"><a href='../../rush/html/Rush.html#method-Rush-retry_tasks'><code>rush::Rush$retry_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="start_local_workers"><a href='../../rush/html/Rush.html#method-Rush-start_local_workers'><code>rush::Rush$start_local_workers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="start_remote_workers"><a href='../../rush/html/Rush.html#method-Rush-start_remote_workers'><code>rush::Rush$start_remote_workers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="stop_workers"><a href='../../rush/html/Rush.html#method-Rush-stop_workers'><code>rush::Rush$stop_workers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="tasks_with_state"><a href='../../rush/html/Rush.html#method-Rush-tasks_with_state'><code>rush::Rush$tasks_with_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="wait_for_finished_tasks"><a href='../../rush/html/Rush.html#method-Rush-wait_for_finished_tasks'><code>rush::Rush$wait_for_finished_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="wait_for_new_tasks"><a href='../../rush/html/Rush.html#method-Rush-wait_for_new_tasks'><code>rush::Rush$wait_for_new_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="wait_for_tasks"><a href='../../rush/html/Rush.html#method-Rush-wait_for_tasks'><code>rush::Rush$wait_for_tasks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="wait_for_workers"><a href='../../rush/html/Rush.html#method-Rush-wait_for_workers'><code>rush::Rush$wait_for_workers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rush" data-topic="Rush" data-id="write_hashes"><a href='../../rush/html/Rush.html#method-Rush-write_hashes'><code>rush::Rush$write_hashes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RushWorker-new"></a>}}
\if{latex}{\out{\hypertarget{method-RushWorker-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RushWorker$new(
  network_id,
  config = NULL,
  remote,
  worker_id = NULL,
  heartbeat_period = NULL,
  heartbeat_expire = NULL,
  lgr_thresholds = NULL,
  lgr_buffer_size = 0,
  seed = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network_id}}{(\code{character(1)})\cr
Identifier of the rush network.
Controller and workers must have the same instance id.
Keys in Redis are prefixed with the instance id.}

\item{\code{config}}{(\link[redux:redis_config]{redux::redis_config})\cr
Redis configuration options.
If \code{NULL}, configuration set by \code{\link[=rush_plan]{rush_plan()}} is used.
If \code{rush_plan()} has not been called, the \code{REDIS_URL} environment variable is parsed.
If \code{REDIS_URL} is not set, a default configuration is used.
See \link[redux:redis_config]{redux::redis_config} for details.}

\item{\code{remote}}{(\code{logical(1)})\cr
Whether the worker is started on a remote machine.
See \link{Rush} for details.}

\item{\code{worker_id}}{(\code{character(1)})\cr
Identifier of the worker.
Keys in redis specific to the worker are prefixed with the worker id.}

\item{\code{heartbeat_period}}{(\code{integer(1)})\cr
Period of the heartbeat in seconds.}

\item{\code{heartbeat_expire}}{(\code{integer(1)})\cr
Time to live of the heartbeat in seconds.}

\item{\code{lgr_thresholds}}{(named \code{character()} | named \code{numeric()})\cr
Logger threshold on the workers e.g. \code{c(rush = "debug")}.}

\item{\code{lgr_buffer_size}}{(\code{integer(1)})\cr
By default (\code{lgr_buffer_size = 0}), the log messages are directly saved in the Redis data store.
If \code{lgr_buffer_size > 0}, the log messages are buffered and saved in the Redis data store when the buffer is full.
This improves the performance of the logging.}

\item{\code{seed}}{(\code{integer()})\cr
Initial seed for the random number generator.
Either a L'Ecuyer-CMRG seed (\code{integer(7)}) or a regular RNG seed (\code{integer(1)}).
The later is converted to a L'Ecuyer-CMRG seed.
If \code{NULL}, no seed is used for the random number generator.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RushWorker-push_running_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-RushWorker-push_running_tasks}{}}}
\subsection{Method \code{push_running_tasks()}}{
Push a task to running tasks without queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RushWorker$push_running_tasks(xss, extra = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xss}}{(list of named \code{list()})\cr
Lists of arguments for the function e.g. \verb{list(list(x1, x2), list(x1, x2)))}.}

\item{\code{extra}}{(\code{list})\cr
List of additional information stored along with the task e.g. \verb{list(list(timestamp), list(timestamp)))}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{character()})\cr
Keys of the tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RushWorker-pop_task"></a>}}
\if{latex}{\out{\hypertarget{method-RushWorker-pop_task}{}}}
\subsection{Method \code{pop_task()}}{
Pop a task from the queue.
Task is moved to the running tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RushWorker$pop_task(timeout = 1, fields = "xs")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{(\code{numeric(1)})\cr
Time to wait for task in seconds.}

\item{\code{fields}}{(\code{character()})\cr
Fields to be returned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RushWorker-push_results"></a>}}
\if{latex}{\out{\hypertarget{method-RushWorker-push_results}{}}}
\subsection{Method \code{push_results()}}{
Pushes results to the data base.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RushWorker$push_results(keys, yss, extra = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{(\code{character(1)})\cr
Keys of the associated tasks.}

\item{\code{yss}}{(named \code{list()})\cr
List of lists of named results.}

\item{\code{extra}}{(named \code{list()})\cr
List of lists of additional information stored along with the results.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RushWorker-set_terminated"></a>}}
\if{latex}{\out{\hypertarget{method-RushWorker-set_terminated}{}}}
\subsection{Method \code{set_terminated()}}{
Mark the worker as terminated.
Last step in the worker loop before the worker terminates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RushWorker$set_terminated()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RushWorker-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RushWorker-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RushWorker$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
