% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heartbeat_loops.R
\name{heartbeat}
\alias{heartbeat}
\title{Heartbeat Loop}
\usage{
heartbeat(
  network_id,
  config,
  worker_id,
  heartbeat_period,
  heartbeat_expire,
  pid
)
}
\arguments{
\item{network_id}{(\code{character(1)})\cr
Identifier of the rush network.
Controller and workers must have the same instance id.
Keys in Redis are prefixed with the instance id.}

\item{config}{(\link[redux:redis_config]{redux::redis_config})\cr
Redis configuration options.}

\item{worker_id}{(\code{character(1)})\cr
Identifier of the worker.
Keys in redis specific to the worker are prefixed with the worker id.}

\item{heartbeat_period}{(\code{integer(1)})\cr
Period of the heartbeat in seconds.}

\item{heartbeat_expire}{(\code{integer(1)})\cr
Time to live of the heartbeat in seconds.}

\item{pid}{(\code{integer(1)})\cr
Process ID of the worker.}
}
\value{
\code{NULL}
}
\description{
The heartbeat loop updates the heartbeat key if the worker is still alive.
If the kill key is set, the worker is killed.
This function is called in a callr session.
}
\examples{
# This example is not executed since Redis must be installed
\donttest{
   config_local = redux::redis_config()

   rush_plan(
     config = config_local,
     n_workers = 2,
     lgr_thresholds = c(rush = "info"))

   rush = rsh(network_id = "test_network")

   fun = function(x1, x2, ...) list(y = x1 + x2)
   rush$start_local_workers(
     fun = fun,
     heartbeat_period = 3,
     heartbeat_expire = 9)

   rush$stop_workers()
}
}
\keyword{internal}
