% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rush_plan.R
\name{rush_plan}
\alias{rush_plan}
\title{Create Rush Plan}
\usage{
rush_plan(
  n_workers = NULL,
  config = NULL,
  lgr_thresholds = NULL,
  lgr_buffer_size = NULL,
  large_objects_path = NULL,
  worker_type = "local"
)
}
\arguments{
\item{n_workers}{(\code{integer(1)})\cr
Number of workers to be started.}

\item{config}{(\link[redux:redis_config]{redux::redis_config})\cr
Configuration options used to connect to Redis.
If \code{NULL}, the \code{REDIS_URL} environment variable is parsed.
If \code{REDIS_URL} is not set, a default configuration is used.
See \link[redux:redis_config]{redux::redis_config} for details.}

\item{lgr_thresholds}{(named \code{character()} | named \code{numeric()})\cr
Logger threshold on the workers e.g. \code{c(rush = "debug")}.}

\item{lgr_buffer_size}{(\code{integer(1)})\cr
By default (\code{lgr_buffer_size = 0}), the log messages are directly saved in the Redis data store.
If \code{lgr_buffer_size > 0}, the log messages are buffered and saved in the Redis data store when the buffer is full.
This improves the performance of the logging.}

\item{large_objects_path}{(\code{character(1)})\cr
The path to the directory where large objects are stored.}

\item{worker_type}{(\code{character(1)})\cr
The type of worker to use.
Options are \code{"local"} to start with \CRANpkg{processx}, \code{"remote"} to use \CRANpkg{mirai} or \code{"script"} to get a script to run.}
}
\value{
\code{list()} with the stored configuration.
}
\description{
Stores the number of workers and Redis configuration options (\link[redux:redis_config]{redux::redis_config}) for \link{Rush}.
The function tests the connection to Redis and throws an error if the connection fails.
This function is usually used in third-party packages to setup how workers are started.
}
\examples{
# This example is not executed since Redis must be installed
\donttest{
   config_local = redux::redis_config()
   rush_plan(config = config_local, n_workers = 2)

   rush = rsh(network_id = "test_network")
   rush
}
}
