% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbols.Comon.R
\name{getSymbols.Comon}
\alias{getSymbols.Comon}
\title{Download data from Comon copytrading platform}
\usage{
getSymbols.Comon(
  Symbols,
  env = globalenv(),
  period = "day",
  verbose = TRUE,
  auto.assign = FALSE,
  ...
)
}
\arguments{
\item{Symbols}{a character id of strategy on Comon}

\item{env}{environment where to create the downloaded data object.}

\item{period}{a character string indicating the frequency of the data to download. Possible values are 'day'.}

\item{verbose}{a logical indicating whether to print the response details or not.}

\item{auto.assign}{a logical indicating whether to automatically assign the downloaded data to the global environment.}

\item{...}{additional arguments passed to getSymbols.Comon}
}
\value{
returns an data.table object containing financial data
}
\description{
Download historical market data from Comon for a given trader id
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
getSymbols.Comon('115038')
getSymbols('115039',src='Comon')
}
\author{
Vyacheslav Arbuzov
}
