% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbols.Poloniex.R
\name{getSymbols.Poloniex}
\alias{getSymbols.Poloniex}
\title{Get financial data from Poloniex}
\usage{
getSymbols.Poloniex(
  Symbols,
  env,
  return.class = "xts",
  index.class = "Date",
  from = "2007-01-01",
  to = Sys.Date(),
  adjust = FALSE,
  period = "day",
  verbose = TRUE,
  auto.assign = FALSE,
  ...
)
}
\arguments{
\item{Symbols}{A character vector with the ticker symbols to retrieve data for.}

\item{env}{The environment where to create the variables. Default is the current environment.}

\item{return.class}{The class to return. Default is xts.}

\item{index.class}{The class for the index column. Default is Date.}

\item{from}{Start date of the data. Default is '2007-01-01'.}

\item{to}{End date of the data. Default is Sys.Date().}

\item{adjust}{Logical. Adjust the prices. Default is FALSE.}

\item{period}{The period for the candle data. Default is 'day'.}

\item{verbose}{Logical. Print progress messages. Default is TRUE.}

\item{auto.assign}{Logical. Assign data to the environment. Default is FALSE.}

\item{...}{Additional arguments to be passed to functions.}
}
\value{
A list of xts objects if \code{auto.assign} is TRUE, otherwise a single xts object.
}
\description{
This function retrieves financial data from Poloniex.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
getSymbols.Poloniex('BTC_USDT')
#getSymbols('BTC_USDT',src='Poloniex')

}
\author{
Vyacheslav Arbuzov
}
