% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_diagnostics.R
\name{summary.ru}
\alias{summary.ru}
\title{Summarizing ratio-of-uniforms samples}
\usage{
\method{summary}{ru}(object, ...)
}
\arguments{
\item{object}{an object of class "ru", a result of a call to
\code{ru}.}

\item{...}{Additional arguments passed on to \code{print} or \code{summary}.}
}
\value{
Prints
\itemize{
  \item {a summary of the simulated values, via
    \code{summary(object$sim_vals)}}
  \item {an estimate of the probability of acceptance, i.e.
    \code{object$pa}}
  \item {information about the ratio-of-uniforms bounding box, i.e.
    \code{object$box}}
}
}
\description{
\code{summary} method for class "ru"
}
\examples{
# one-dimensional standard normal ----------------
x <- ru(logf = function(x) -x ^ 2 / 2, d = 1, n = 1000, init = 0)
summary(x)

# two-dimensional normal with positive association ----------------
rho <- 0.9
covmat <- matrix(c(1, rho, rho, 1), 2, 2)
log_dmvnorm <- function(x, mean = rep(0, d), sigma = diag(d)) {
  x <- matrix(x, ncol = length(x))
  d <- ncol(x)
  - 0.5 * (x - mean) \%*\% solve(sigma) \%*\% t(x - mean)
}
x <- ru(logf = log_dmvnorm, sigma = covmat, d = 2, n = 1000, init = c(0, 0))
summary(x)
}
\seealso{
\code{\link{ru}} for descriptions of \code{object$sim_vals} and
  \code{object$box}.

\code{\link{plot.ru}} for a diagnostic plot (for \code{d} = 1
  and \code{d} = 2 only).
}

