% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_sparse.R
\name{sparsity}
\alias{sparsity}
\title{Sparsity regularization}
\usage{
sparsity(high_probability, weight)
}
\arguments{
\item{high_probability}{Expected probability of the high value of the
encoding layer. Set this to a value near zero in order to minimize
activations in that layer.}

\item{weight}{The weight of the sparsity regularization}
}
\value{
A Ruta regularizer object for the sparsity, to be inserted in the
encoding layer.
}
\description{
Sparsity regularization
}
\references{
\itemize{
\item \href{http://papers.nips.cc/paper/3313-sparse-deep-belief-net-model-for-visual-area-v2}{Sparse deep belief net model for visual area V2}
\item Andrew Ng, Sparse Autoencoder.
\href{https://web.stanford.edu/class/cs294a/sparseAutoencoder_2011new.pdf}{CS294A Lecture Notes}
}
}
\seealso{
\code{\link{autoencoder_sparse}}, \code{\link{make_sparse}}, \code{\link{is_sparse}}
}
