% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_rv.R
\name{quantile.rv}
\alias{quantile.rv}
\title{Distribution of a Quantile of a Random Vector}
\usage{
\method{quantile}{rv}(x, ...)
}
\arguments{
\item{x}{an object}

\item{\dots}{further arguments passed to or from other methods}
}
\value{
A random vector (rv object) with components giving the distribution
of the desired quantiles.
}
\description{
\code{quantile.rv} returns the distribution of the quantile of a random
vector (as a random variable).
}
\note{
\code{quantile.rv} does not return the simulated quantiles of the
quantiles of the argument \code{x}.  This is done by
\code{\link{rvquantile}}.
}
\examples{

  x <- rvnorm(30)
  quantile(x)

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
