% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvconst.R
\name{rvconst}
\alias{rvconst}
\title{Random Vector with a Point-Mass Distribution}
\usage{
rvconst(n = 1, x = 0)
}
\arguments{
\item{n}{integer: number of variables to generate}

\item{x}{a vector of constants}
}
\value{
A random vector (rv object) of length \code{n}.
}
\description{
Coerces a given vector of constants into a random vector with 1 simulation
in each component.
}
\details{
Coerces a given vector of constants into a random vector with 1 simulation
in each component.
}
\examples{

  x <- rvconst(x=1:3)
  c(x, 4)

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
