\name{NBA1314}
\alias{NBA1314}
\docType{data}
\title{
National Basketball Association, free throw data, 2013-2014 season
}
\description{Free throw statistics on 482 active players, 2013-2014 season}
\usage{data(NBA1314)}
\format{
  A data frame with 482 players (rows) variables including.
  \describe{
    \item{\code{RK}}{rank of player by proportion of free throws made}
    \item{\code{PLAYER}}{name of player} 
    \item{\code{TEAM}}{player's team}
    \item{\code{GP}}{games played}
    \item{\code{PPG}}{points per game} 
    \item{\code{FTM0}}{FTM/GP}
    \item{\code{FTA0}}{FTA/GP}
    \item{\code{FTA}}{free throws attempted} 
    \item{\code{FTM}}{free throws made} 
    \item{\code{FTprop}}{FTA/FTM} 
    }
  }
\details{
Data obtained from ESPN.
}
\references{See data analyzed in Henderson and Newton, 2015}
\examples{
data(NBA1314)
nba.dat <- cbind(NBA1314$FTM, NBA1314$FTA)
rownames(nba.dat) <- NBA1314$PLAYER

rvals.nba <- rvalues(nba.dat, family=binomial)
}
\keyword{datasets}
