% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/html.R
\name{html}
\alias{html}
\title{Parse an HTML page.}
\usage{
html(x, ..., encoding = NULL)
}
\arguments{
\item{x}{A url, a local path, a string containing html, or a response from
an httr request.}

\item{...}{If \code{x} is a URL, additional arguments are passed on to
\code{\link[httr]{GET}()}.}

\item{encoding}{Specify encoding of document. See \code{\link{iconvlist}()}
for complete list. If you have problems determining the correct encoding,
try \code{\link[stringi]{stri_enc_detect}}}
}
\description{
Parse an HTML page.
}
\examples{
# From a url:
google <- html("http://google.com")
google \%>\% xml_structure()
google \%>\% html_nodes("p")

# From a string: (minimal html 5 document)
# http://www.brucelawson.co.uk/2010/a-minimal-html5-document/
minimal <- html("<!doctype html>
  <meta charset=utf-8>
 <title>blah</title>
 <p>I'm the content")
minimal

# From an httr request
google2 <- html(httr::GET("http://google.com"))
}

